/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.ui.properties.internal;

/**
 * A list of debug options for this plug-in.
 * 
 * @author Anthony Hunter 
 * <a href="mailto:anthonyh@ca.ibm.com">anthonyh@ca.ibm.com</a>
 */
public final class CommonUIPropertiesDebugOptions {

	/**
	 * This class should not be instantiated since it is a static constant
	 * class.
	 * 
	 */
	private CommonUIPropertiesDebugOptions() {
		/* not used */
	}

	public static final String DEBUG = CommonUIPropertiesPlugin.getPlugin() + "/debug"; //$NON-NLS-1$

	public static final String EXCEPTIONS_CATCHING = DEBUG + "/exceptions/catching"; //$NON-NLS-1$
	public static final String EXCEPTIONS_THROWING = DEBUG + "/exceptions/throwing"; //$NON-NLS-1$

	public static final String METHODS_ENTERING = DEBUG + "/methods/entering"; //$NON-NLS-1$
	public static final String METHODS_EXITING = DEBUG + "/methods/exiting"; //$NON-NLS-1$

	public static final String ACTIONS_ADMIN = DEBUG + "/actions/admin"; //$NON-NLS-1$
	public static final String ACTIONS_RUN = DEBUG + "/actions/run"; //$NON-NLS-1$
	public static final String ACTIONS_REPEAT = DEBUG + "/actions/repeat"; //$NON-NLS-1$
	public static final String DND = DEBUG + "/dnd/tracing"; //$NON-NLS-1$	
	public static final String RESOURCE = DEBUG + "/resource/tracing"; //$NON-NLS-1$	

	public static final String SERVICES_CONFIG = DEBUG + "/services/config"; //$NON-NLS-1$
}
