/*******************************************************************************
* Copyright (c) 2000, 2004 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
package org.eclipse.wst.rdb.internal.outputview;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * A dialog to show a string value that cannot be shown entirely
 * in the column of a table.
 */
public class DialogShowLongField extends Dialog
{
   /** A push button to close the dialog. */
   protected Button btnClose;
   /** A string to display in the dialog. */
   protected String msg;
   /** The window title of the dialog. */
   protected String title;
   /** The maxiumum length of a value to show in this dialog. */
   static final int TRUNCATEDISPLAYLENGTH = 2000;
   /** True if the value to be shown has been truncated. */
   protected boolean truncate;
   /**
    * Constructs the dialog.
    * @param shell The Shell.
    * @param aTitle The title.
    * @param longString The string value to show.
    * @param aTruncate True if the value to be shown has been truncated.
    */
   public  DialogShowLongField(Shell shell, String aTitle, String longString, boolean aTruncate)
   {
      super(shell);
      msg = longString;
      title = aTitle;
      truncate = aTruncate;
   }
   
   /**
    * Sets the window title when the shell is configured.
    * @param newShell The shell.
    */
   protected void configureShell(Shell newShell)
   {
      super.configureShell(newShell);
      newShell.setText(title);
   }
   
   /** 
    * Sets the shell style when the dialog is opened.
    */
   public int open()
   {
      setShellStyle(getShellStyle() | SWT.RESIZE);
      return super.open();
   }
   
   /**
    * Creates the elements of the dialog area.
    * @param parent The parent composite.
    * @return The dialog area.
    */
   protected Control createDialogArea(Composite parent)
   {
      Composite composite = (Composite) super.createDialogArea(parent);
      GridData gridData, gridData1;
      
      GridLayout gridLayout = new GridLayout();
      gridLayout.numColumns = 1;
      composite.setLayout(gridLayout);
      
      gridData1 = new GridData();
      gridData1.grabExcessHorizontalSpace = true;
      gridData1.horizontalAlignment = GridData.FILL;
      gridData1.grabExcessVerticalSpace = true;
      gridData1.verticalAlignment = GridData.FILL;
      
      gridData1.widthHint = 480;
      gridData1.heightHint = 300;
      
      Label truncated= null;
      if (truncate && msg.length() > TRUNCATEDISPLAYLENGTH)
         truncated = new Label(composite, SWT.LEFT);
      
      Text txtStatement = new Text(composite, SWT.WRAP |SWT.READ_ONLY| SWT.MULTI | SWT.V_SCROLL
            | SWT.BORDER);
      if (truncate && msg.length() > TRUNCATEDISPLAYLENGTH) {
         truncated.setText(OutputViewPlugin.getString("OV_DISPLAY_TRUNCATED"));
         msg = msg.substring(0,TRUNCATEDISPLAYLENGTH);
      }
      txtStatement.setText(msg);
      txtStatement.setLayoutData(gridData1);
      
      
      return composite;
   }
   
   /**
    * Creates just one close button
    * with Cancel-Button-behavior, thereby we can reuse cancelPressed().
    * @param parent Our parent composite.
    */
   protected void createButtonsForButtonBar(Composite parent)
   {
      btnClose = createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CLOSE_LABEL, false);
   }
}


