/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public final class AddDelegateMethodsOperation
implements IWorkspaceRunnable {
    private boolean fApply = true;
    private final List fCreated = new ArrayList();
    private TextEdit fEdit = null;
    private final IJavaElement fInsert;
    private final String[] fMethodKeys;
    private final boolean fSave;
    private final CodeGenerationSettings fSettings;
    private final IType fType;
    private final CompilationUnit fUnit;
    private final String[] fVariableKeys;

    public AddDelegateMethodsOperation(IType type, IJavaElement insert, CompilationUnit unit, String[] variableKeys, String[] methodKeys, CodeGenerationSettings settings, boolean apply, boolean save) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)variableKeys);
        Assert.isNotNull((Object)methodKeys);
        Assert.isNotNull((Object)settings);
        Assert.isTrue((variableKeys.length == methodKeys.length ? 1 : 0) != 0);
        this.fType = type;
        this.fInsert = insert;
        this.fUnit = unit;
        this.fVariableKeys = variableKeys;
        this.fMethodKeys = methodKeys;
        this.fSettings = settings;
        this.fSave = save;
        this.fApply = apply;
    }

    public final String[] getCreatedMethods() {
        String[] keys = new String[this.fCreated.size()];
        this.fCreated.toArray(keys);
        return keys;
    }

    public final TextEdit getResultingEdit() {
        return this.fEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        block29: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                IBinding[][] bindings;
                monitor.beginTask("", 1);
                monitor.setTaskName(CodeGenerationMessages.AddDelegateMethodsOperation_monitor_message);
                this.fCreated.clear();
                ICompilationUnit unit = this.fType.getCompilationUnit();
                CompilationUnitRewrite rewrite = new CompilationUnitRewrite(unit, this.fUnit);
                ITypeBinding binding = null;
                ListRewrite rewriter = null;
                if (this.fType.isAnonymous()) {
                    AnonymousClassDeclaration declaration;
                    IJavaElement parent = this.fType.getParent();
                    if (parent instanceof IField && Flags.isEnum((int)((IMember)parent).getFlags())) {
                        EnumConstantDeclaration constant = (EnumConstantDeclaration)NodeFinder.perform((ASTNode)rewrite.getRoot(), ((ISourceReference)parent).getSourceRange());
                        if (constant != null && (declaration = constant.getAnonymousClassDeclaration()) != null && (binding = declaration.resolveBinding()) != null) {
                            rewriter = rewrite.getASTRewrite().getListRewrite((ASTNode)declaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                        }
                    } else {
                        ClassInstanceCreation creation = (ClassInstanceCreation)ASTNodes.getParent(NodeFinder.perform((ASTNode)rewrite.getRoot(), this.fType.getNameRange()), ClassInstanceCreation.class);
                        if (creation != null) {
                            binding = creation.resolveTypeBinding();
                            declaration = creation.getAnonymousClassDeclaration();
                            if (declaration != null) {
                                rewriter = rewrite.getASTRewrite().getListRewrite((ASTNode)declaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
                            }
                        }
                    }
                } else {
                    AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(NodeFinder.perform((ASTNode)rewrite.getRoot(), this.fType.getNameRange()), AbstractTypeDeclaration.class);
                    if (declaration != null) {
                        binding = declaration.resolveBinding();
                        rewriter = rewrite.getASTRewrite().getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
                    }
                }
                if (binding == null || rewriter == null || (bindings = StubUtility2.getDelegatableMethods(rewrite.getAST(), binding)) == null || bindings.length <= 0) break block29;
                ITextFileBuffer buffer = null;
                IDocument document = null;
                try {
                    CompilationUnitChange change;
                    TextEdit edit;
                    if (!JavaModelUtil.isPrimary(unit)) {
                        document = new Document(unit.getBuffer().getContents());
                    } else {
                        buffer = RefactoringFileBuffers.acquire(unit);
                        document = buffer.getDocument();
                    }
                    ASTNode insertion = null;
                    if (this.fInsert instanceof IMethod) {
                        insertion = ASTNodes.getParent(NodeFinder.perform((ASTNode)rewrite.getRoot(), ((IMethod)this.fInsert).getNameRange()), MethodDeclaration.class);
                    }
                    String variableKey = null;
                    String methodKey = null;
                    MethodDeclaration stub = null;
                    int index = 0;
                    while (index < this.fMethodKeys.length) {
                        methodKey = this.fMethodKeys[index];
                        variableKey = this.fVariableKeys[index];
                        if (monitor.isCanceled()) break;
                        int offset = 0;
                        while (offset < bindings.length) {
                            if (bindings[offset][0].getKey().equals(variableKey) && bindings[offset][1].getKey().equals(methodKey)) {
                                stub = StubUtility2.createDelegationStub(rewrite.getCu(), rewrite.getASTRewrite(), rewrite.getImportRewrite(), rewrite.getAST(), bindings[offset], this.fSettings);
                                if (stub == null) break;
                                this.fCreated.add(methodKey);
                                if (insertion != null) {
                                    rewriter.insertBefore((ASTNode)stub, insertion, null);
                                    break;
                                }
                                rewriter.insertLast((ASTNode)stub, null);
                                break;
                            }
                            ++offset;
                        }
                        ++index;
                    }
                    CompilationUnitChange result = rewrite.createChange();
                    if (!(result instanceof CompilationUnitChange) || (edit = (change = result).getEdit()) == null) break block29;
                    try {
                        this.fEdit = edit;
                        if (this.fApply) {
                            edit.apply(document, 2);
                        }
                        if (this.fSave) {
                            if (buffer != null) {
                                buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
                            } else {
                                unit.getBuffer().setContents(document.get());
                            }
                        }
                    }
                    catch (Exception exception) {
                        throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, exception.getLocalizedMessage(), (Throwable)exception));
                    }
                }
                finally {
                    if (buffer != null) {
                        RefactoringFileBuffers.release(unit);
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

