/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public class CompilationUnitBuffer {
    private IScanner fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
    private int fSourceLength;

    public CompilationUnitBuffer(ICompilationUnit unit) throws JavaModelException {
        char[] source = unit.getBuffer().getCharacters();
        this.fScanner.setSource(source);
        this.fSourceLength = source.length;
    }

    public char[] getCharacters() {
        return this.fScanner.getSource();
    }

    public char getCharAt(int index) {
        return this.fScanner.getSource()[index];
    }

    public int indexOf(int token, int start) {
        return this.indexOf(token, start, this.fSourceLength - start);
    }

    public int indexOf(int token, int start, int length) {
        if (length <= 0) {
            return -1;
        }
        try {
            int next;
            this.fScanner.resetTo(start, start + length - 1);
            while ((next = this.fScanner.getNextToken()) != 158) {
                if (next != token) continue;
                return this.fScanner.getCurrentTokenStartPosition();
            }
            return -1;
        }
        catch (InvalidInputException invalidInputException) {
            return -1;
        }
    }

    public int indexAfter(int token, int start) {
        int result = this.indexOf(token, start);
        if (result == -1) {
            return result;
        }
        return this.fScanner.getCurrentTokenEndPosition() + 1;
    }

    public int indexOfNextToken(int start, boolean considerComments) {
        try {
            int token;
            this.fScanner.resetTo(start, this.fSourceLength - 1);
            while ((token = this.fScanner.getNextToken()) != 158) {
                if (!considerComments && this.isComment(token)) continue;
                return this.fScanner.getCurrentTokenStartPosition();
            }
            return -1;
        }
        catch (InvalidInputException invalidInputException) {
            return -1;
        }
    }

    private boolean isComment(int token) {
        return token == 1002 || token == 1003 || token == 1001;
    }
}

