/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public abstract class CompositeImageDescriptor
extends ImageDescriptor {
    private ImageData imageData;

    protected CompositeImageDescriptor() {
    }

    private static int alloc(RGB[] map, int red, int green, int blue) {
        RGB c;
        int i = 1;
        while (i < map.length && (c = map[i]) != null) {
            if (c.red == red && c.green == green && c.blue == blue) {
                return i;
            }
            ++i;
        }
        if (i < map.length - 1) {
            map[i] = new RGB(red, green, blue);
            return i;
        }
        return 0;
    }

    protected abstract void drawCompositeImage(int var1, int var2);

    protected final void drawImage(ImageData src, int ox, int oy) {
        RGB[] out = this.imageData.getRGBs();
        PaletteData palette = src.palette;
        if (palette.isDirect) {
            ImageData mask = src.getTransparencyMask();
            int y = 0;
            while (y < src.height) {
                int x = 0;
                while (x < src.width) {
                    if (mask.getPixel(x, y) != 0) {
                        int xx = x + ox;
                        int yy = y + oy;
                        if (xx >= 0 && xx < this.imageData.width && yy >= 0 && yy < this.imageData.height) {
                            int pixel = src.getPixel(x, y);
                            int r = pixel & palette.redMask;
                            r = palette.redShift < 0 ? r >>> -palette.redShift : r << palette.redShift;
                            int g = pixel & palette.greenMask;
                            g = palette.greenShift < 0 ? g >>> -palette.greenShift : g << palette.greenShift;
                            int b = pixel & palette.blueMask;
                            b = palette.blueShift < 0 ? b >>> -palette.blueShift : b << palette.blueShift;
                            pixel = CompositeImageDescriptor.alloc(out, r, g, b);
                            this.imageData.setPixel(xx, yy, pixel);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            return;
        }
        int[] map = new int[256];
        int i = 0;
        while (i < map.length) {
            map[i] = -1;
            ++i;
        }
        if (src.getTransparencyType() == 2) {
            ImageData mask = src.getTransparencyMask();
            int y = 0;
            while (y < src.height) {
                int x = 0;
                while (x < src.width) {
                    if (mask.getPixel(x, y) != 0) {
                        int xx = x + ox;
                        int yy = y + oy;
                        if (xx >= 0 && xx < this.imageData.width && yy >= 0 && yy < this.imageData.height) {
                            int pixel = src.getPixel(x, y);
                            int newPixel = map[pixel];
                            if (newPixel < 0) {
                                RGB c = palette.getRGB(pixel);
                                map[pixel] = newPixel = CompositeImageDescriptor.alloc(out, c.red, c.green, c.blue);
                            }
                            this.imageData.setPixel(xx, yy, newPixel);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            return;
        }
        int maskPixel = src.transparentPixel;
        int y = 0;
        while (y < src.height) {
            int x = 0;
            while (x < src.width) {
                int pixel = src.getPixel(x, y);
                if (maskPixel < 0 || pixel != maskPixel) {
                    int xx = x + ox;
                    int yy = y + oy;
                    if (xx >= 0 && xx < this.imageData.width && yy >= 0 && yy < this.imageData.height) {
                        int newPixel = map[pixel];
                        if (newPixel < 0) {
                            RGB c = palette.getRGB(pixel);
                            map[pixel] = newPixel = CompositeImageDescriptor.alloc(out, c.red, c.green, c.blue);
                        }
                        this.imageData.setPixel(xx, yy, newPixel);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    public ImageData getImageData() {
        Point size = this.getSize();
        RGB black = new RGB(0, 0, 0);
        RGB[] rgbs = new RGB[256];
        rgbs[0] = black;
        rgbs[1] = black;
        PaletteData dataPalette = new PaletteData(rgbs);
        this.imageData = new ImageData(size.x, size.y, 8, dataPalette);
        this.imageData.transparentPixel = 0;
        this.drawCompositeImage(size.x, size.y);
        int i = 0;
        while (i < rgbs.length) {
            if (rgbs[i] == null) {
                rgbs[i] = black;
            }
            ++i;
        }
        return this.imageData;
    }

    protected abstract Point getSize();
}

