/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JarPackageFragmentInfo;
import org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.jdt.internal.core.util.Util;

public class JarPackageFragmentRoot
extends PackageFragmentRoot {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath jarPath;

    protected JarPackageFragmentRoot(IPath jarPath, JavaProject project) {
        super(null, project);
        this.jarPath = jarPath;
    }

    protected JarPackageFragmentRoot(IResource resource, JavaProject project) {
        super(resource, project);
        this.jarPath = resource.getFullPath();
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws JavaModelException {
        ArrayList<JarPackageFragment> vChildren = new ArrayList<JarPackageFragment>();
        ZipFile jar = null;
        try {
            try {
                jar = this.getJar();
                HashtableOfArrayToObject packageFragToTypes = new HashtableOfArrayToObject();
                packageFragToTypes.put(CharOperation.NO_STRINGS, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
                Enumeration<? extends ZipEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    ZipEntry member = e.nextElement();
                    String entryName = member.getName();
                    if (member.isDirectory()) {
                        this.initPackageFragToTypes(packageFragToTypes, entryName, entryName.length() - 1);
                        continue;
                    }
                    int lastSeparator = entryName.lastIndexOf(47);
                    String fileName = entryName.substring(lastSeparator + 1);
                    Object[] pkgName = this.initPackageFragToTypes(packageFragToTypes, entryName, lastSeparator);
                    ArrayList[] children = (ArrayList[])packageFragToTypes.get(pkgName);
                    if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) {
                        if (children[0] == EMPTY_LIST) {
                            children[0] = new ArrayList();
                        }
                        children[0].add(fileName);
                        continue;
                    }
                    if (children[1] == EMPTY_LIST) {
                        children[1] = new ArrayList();
                    }
                    children[1].add(fileName);
                }
                int i = 0;
                int length = packageFragToTypes.keyTable.length;
                while (i < length) {
                    Object[] pkgName = (String[])packageFragToTypes.keyTable[i];
                    if (pkgName != null) {
                        ArrayList[] entries = (ArrayList[])packageFragToTypes.get(pkgName);
                        JarPackageFragment packFrag = (JarPackageFragment)this.getPackageFragment((String[])pkgName);
                        JarPackageFragmentInfo fragInfo = new JarPackageFragmentInfo();
                        int resLength = entries[1].size();
                        if (resLength == 0) {
                            packFrag.computeNonJavaResources(CharOperation.NO_STRINGS, fragInfo, jar.getName());
                        } else {
                            String[] resNames = new String[resLength];
                            entries[1].toArray(resNames);
                            packFrag.computeNonJavaResources(resNames, fragInfo, jar.getName());
                        }
                        packFrag.computeChildren(fragInfo, entries[0]);
                        newElements.put(packFrag, fragInfo);
                        vChildren.add(packFrag);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
        finally {
            JavaModelManager.getJavaModelManager().closeZipFile(jar);
        }
        IJavaElement[] children = new IJavaElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    protected Object createElementInfo() {
        return new JarPackageFragmentRootInfo();
    }

    protected int determineKind(IResource underlyingResource) {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JarPackageFragmentRoot) {
            JarPackageFragmentRoot other = (JarPackageFragmentRoot)o;
            return this.jarPath.equals((Object)other.jarPath);
        }
        return false;
    }

    public String getElementName() {
        return this.jarPath.lastSegment();
    }

    public ZipFile getJar() throws CoreException {
        return JavaModelManager.getJavaModelManager().getZipFile(this.getPath());
    }

    public int getKind() {
        return 2;
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((JarPackageFragment)this.getPackageFragment(CharOperation.NO_STRINGS)).storedNonJavaResources();
    }

    public PackageFragment getPackageFragment(String[] pkgName) {
        return new JarPackageFragment(this, pkgName);
    }

    public IPath getPath() {
        if (this.isExternal()) {
            return this.jarPath;
        }
        return super.getPath();
    }

    public IResource getResource() {
        if (this.resource == null) {
            this.resource = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.jarPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    public int hashCode() {
        return this.jarPath.hashCode();
    }

    private String[] initPackageFragToTypes(HashtableOfArrayToObject packageFragToTypes, String entryName, int lastSeparator) {
        int length;
        Object[] pkgName = Util.splitOn('/', entryName, 0, lastSeparator);
        Object[] existing = null;
        int existingLength = length = pkgName.length;
        while (existingLength >= 0) {
            existing = (String[])packageFragToTypes.getKey(pkgName, existingLength);
            if (existing != null) break;
            --existingLength;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = existingLength;
        while (i < length) {
            Object[] objectArray = existing;
            existing = new String[i + 1];
            System.arraycopy(objectArray, 0, existing, 0, i);
            existing[i] = manager.intern((String)pkgName[i]);
            packageFragToTypes.put(existing, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            ++i;
        }
        return existing;
    }

    public boolean isArchive() {
        return true;
    }

    public boolean isExternal() {
        return this.getResource() == null;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected boolean resourceExists() {
        if (this.isExternal()) {
            return JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.getPath(), true) != null;
        }
        return super.resourceExists();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }
}

