/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.operations.IUnconfigureAndUninstallFeatureOperation;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.views.FeatureAction;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class UnconfigureAndUninstallFeatureAction
extends FeatureAction {
    private ConfiguredFeatureAdapter adapter;

    public UnconfigureAndUninstallFeatureAction(Shell shell, String text) {
        super(shell, text);
        this.setWindowTitle(UpdateUIMessages.FeatureUnconfigureAndUninstallAction_dialogTitle);
    }

    public void run() {
        try {
            IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
            if (status != null) {
                throw new CoreException(status);
            }
            if (this.adapter == null || !this.confirm(UpdateUIMessages.FeatureUnconfigureAndUninstallAction_question)) {
                return;
            }
            if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUIMessages.Actions_brokenConfigQuestion)) {
                return;
            }
            IUnconfigureAndUninstallFeatureOperation operation = ((OperationFactory)OperationsManager.getOperationFactory()).createUnconfigureAndUninstallFeatureOperation(this.adapter.getConfiguredSite(), this.adapter.getFeature(null));
            boolean restartNeeded = operation.execute(null, null);
            UpdateUI.requestRestart(restartNeeded);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)e.getStatus());
        }
        catch (InvocationTargetException e) {
            UpdateUtils.logException((Throwable)e.getTargetException());
        }
    }

    public void setSelection(IStructuredSelection selection) {
        this.adapter = (ConfiguredFeatureAdapter)selection.getFirstElement();
        this.setText(UpdateUIMessages.FeatureUnconfigureAndUninstallAction_uninstall);
    }

    public boolean canExecuteAction() {
        block5: {
            if (this.adapter == null) {
                return false;
            }
            if (!this.adapter.isConfigured()) {
                return false;
            }
            try {
                IFeatureOperation pendingOperation = OperationsManager.findPendingOperation((IFeature)this.adapter.getFeature(null));
                if (pendingOperation == null) break block5;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return InstallRegistry.getInstance().get((Object)("feature_" + this.adapter.getFeature(null).getVersionedIdentifier())) != null;
    }
}

