/*
 * Decompiled with CFR 0.152.
 */
package java.security;

final class VMSecureRandom {
    static int generateSeed(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("length must be nonnegative");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Spinner[] spinnerArray = new Spinner[8];
        int n4 = 1;
        for (n3 = 0; n3 < spinnerArray.length; ++n3) {
            spinnerArray[n3] = new Spinner((byte)n4);
            Thread thread = new Thread(spinnerArray[n3]);
            thread.start();
            n4 <<= 1;
        }
        while (!(spinnerArray[0].running || spinnerArray[1].running || spinnerArray[2].running || spinnerArray[3].running || spinnerArray[4].running || spinnerArray[5].running || spinnerArray[6].running || spinnerArray[7].running)) {
            Thread.yield();
        }
        for (n3 = n; n3 < n2; ++n3) {
            byArray[n3] = spinnerArray[0].value ^ spinnerArray[1].value ^ spinnerArray[2].value ^ spinnerArray[3].value ^ spinnerArray[4].value ^ spinnerArray[5].value ^ spinnerArray[6].value ^ spinnerArray[7].value;
            Thread.yield();
        }
        for (n3 = 0; n3 < spinnerArray.length; ++n3) {
            spinnerArray[n3].stop();
        }
        return n2;
    }

    VMSecureRandom() {
    }

    static class Spinner
    implements Runnable {
        volatile byte value;
        volatile boolean running;

        Spinner(byte by) {
            this.value = by;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                this.value = (byte)(this.value + 1);
            }
        }

        private void stop() {
            this.running = false;
        }
    }
}

