/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.RE;
import gnu.java.util.regex.REMatch;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    private Pattern pattern;
    private CharSequence input;
    private CharIndexed inputCharIndexed;
    private int position;
    private int appendPosition;
    private REMatch match;

    Matcher(Pattern pattern2, CharSequence charSequence) {
        this.pattern = pattern2;
        this.input = charSequence;
        this.inputCharIndexed = RE.makeCharIndexed(charSequence, 0);
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) throws IllegalStateException {
        this.assertMatchOp();
        stringBuffer.append(this.input.subSequence(this.appendPosition, this.match.getStartIndex()).toString());
        stringBuffer.append(RE.getReplacement(string, this.match, 512));
        this.appendPosition = this.match.getEndIndex();
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(this.input.subSequence(this.appendPosition, this.input.length()).toString());
        return stringBuffer;
    }

    public int end() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex();
    }

    public int end(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex(n);
    }

    public boolean find() {
        boolean bl = this.match == null;
        this.match = this.pattern.getRE().getMatch(this.inputCharIndexed, this.position);
        if (this.match != null) {
            int n = this.match.getEndIndex();
            if (!bl && n == this.position) {
                this.match = null;
                if (this.position < this.input.length() - 1) {
                    ++this.position;
                    return this.find(this.position);
                }
                return false;
            }
            this.position = n;
            return true;
        }
        return false;
    }

    public boolean find(int n) {
        this.match = this.pattern.getRE().getMatch(this.inputCharIndexed, n);
        if (this.match != null) {
            this.position = this.match.getEndIndex();
            return true;
        }
        return false;
    }

    public String group() {
        this.assertMatchOp();
        return this.match.toString();
    }

    public String group(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.toString(n);
    }

    public String replaceFirst(String string) {
        this.reset();
        return this.pattern.getRE().substitute(this.input, string, this.position, 512);
    }

    public String replaceAll(String string) {
        this.reset();
        return this.pattern.getRE().substituteAll(this.input, string, this.position, 512);
    }

    public int groupCount() {
        return this.pattern.getRE().getNumSubs();
    }

    public boolean lookingAt() {
        this.match = this.pattern.getRE().getMatch(this.inputCharIndexed, 0);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                return true;
            }
            this.match = null;
        }
        return false;
    }

    public boolean matches() {
        this.match = this.pattern.getRE().getMatch(this.inputCharIndexed, 0, 256);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                if (this.position == this.input.length()) {
                    return true;
                }
            }
            this.match = null;
        }
        return false;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Matcher reset() {
        this.position = 0;
        this.match = null;
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.input = charSequence;
        return this.reset();
    }

    public int start() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex();
    }

    public int start(int n) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex(n);
    }

    private void assertMatchOp() {
        if (this.match == null) {
            throw new IllegalStateException();
        }
    }
}

