#!/bin/sh
echo 'name: atom
version: 1.0.9
id: atom-1.0.9-724cae60391796c68fac37f5e0c68044

license: BSD3
copyright:
maintainer: Tom Hawkins <tomahawkins@gmail.com>, Lee Pike <leepike@gmail.com>
stability:
homepage: http://tomahawkins.org
package-url:
description: Atom is a Haskell DSL for designing hard realtime embedded software.
             Based on guarded atomic actions (similar to STM), Atom enables
             highly concurrent programming without the need for mutex locking.
             In addition, Atom performs compile-time task scheduling and generates code
             with deterministic execution time and constant memory use, simplifying the
             process of timing verification and memory consumption in hard realtime applications.
             Without mutex locking and run-time task scheduling, Atom eliminates
             the need and overhead of RTOSs for many embedded applications.
category: Language, Embedded
author: Tom Hawkins <tomahawkins@gmail.com>
pkgpath: devel/hs-atom
exposed: True
exposed-modules: Language.Atom Language.Atom.Analysis
                 Language.Atom.Code Language.Atom.Common Language.Atom.Compile
                 Language.Atom.Elaboration Language.Atom.Example
                 Language.Atom.Expressions Language.Atom.Language
                 Language.Atom.Scheduling Language.Atom.Unit Language.Atom.UeMap
hidden-modules:
import-dirs: /usr/local/lib/ghc/atom-1.0.9
library-dirs: /usr/local/lib/ghc/atom-1.0.9
hs-libraries: HSatom-1.0.9
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         bimap-0.2.4-1f13cb41b3e4e0d45ddf437a84d80eeb
         containers-0.4.0.0-8781485edb2ac0db733a9f9c72e27945
         mtl-2.0.1.0-91f62d81c946aa60137dcc008e554a3a
         process-1.0.1.5-55dfaccf3a91c4cb8f6284a0bafef198
         syb-0.3-8a51ec8e05a2a260bc0e1bb18be953b0
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-atom-1.0.9/html/atom.haddock
haddock-html: /usr/local/share/doc/hs-atom-1.0.9/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
