#!/bin/sh
echo 'name: blaze-builder
version: 0.2.1.4
id: blaze-builder-0.2.1.4-1d0b6a4c629586ac068bdee84108579c

license: BSD3
copyright: 2010 Simon Meier
           2010 Jasper Van der Jeugt
maintainer: Simon Meier <iridcode@gmail.com>
stability: Experimental
homepage: http://github.com/meiersi/blaze-builder
package-url:
description: This library provides an abstraction of buffered output of
             byte streams and several convenience functions to exploit
             it. For example, it allows to efficiently serialize
             Haskell values to lazy bytestrings with a large average
             chunk size. The large average chunk size allows to make
             good use of cache prefetching in later processing steps
             (e.g. compression) and reduces the sytem call overhead
             when writing the resulting lazy bytestring to a file or
             sending it over the network.
category: Data
author: Jasper Van der Jeugt, Simon Meier
pkgpath: devel/hs-blaze-builder
exposed: True
exposed-modules: Blaze.ByteString.Builder
                 Blaze.ByteString.Builder.Int Blaze.ByteString.Builder.Word
                 Blaze.ByteString.Builder.ByteString
                 Blaze.ByteString.Builder.Char.Utf8 Blaze.ByteString.Builder.Char8
                 Blaze.ByteString.Builder.Html.Utf8 Blaze.ByteString.Builder.HTTP
                 Blaze.ByteString.Builder.Internal
                 Blaze.ByteString.Builder.Internal.Write
                 Blaze.ByteString.Builder.Internal.Types
                 Blaze.ByteString.Builder.Internal.Buffer
hidden-modules: Blaze.ByteString.Builder.Internal.UncheckedShifts
import-dirs: /usr/local/lib/ghc/blaze-builder-0.2.1.4
library-dirs: /usr/local/lib/ghc/blaze-builder-0.2.1.4
hs-libraries: HSblaze-builder-0.2.1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         bytestring-0.9.1.10-2da7b519f76934c0e733bf92c23382ec
         text-0.11.0.6-8c4af07195c37bf4d73ffb41fc92ea29
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-blaze-builder-0.2.1.4/html/blaze-builder.haddock
haddock-html: /usr/local/share/doc/hs-blaze-builder-0.2.1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
