#!/bin/sh
echo 'name: convertible
version: 1.0.10.0
id: convertible-1.0.10.0-ac601b0c88786ad4f8f48968eb9cd8ee

license: LGPL
copyright: Copyright (c) 2009-2010 John Goerzen
maintainer: John Goerzen <jgoerzen@complete.org>
stability: Stable
homepage: http://hackage.haskell.org/cgi-bin/hackage-scripts/package/convertible
package-url:
description: convertible provides a typeclass with a single function
             that is designed to help convert between different types: numeric
             values, dates and times, and the like.  The conversions perform bounds
             checking and return a pure Either value.  This means that you need
             not remember which specific function performs the conversion you
             desire.
             .
             Also included in the package are optional instances that provide
             conversion for various numeric and time types, as well as utilities
             for writing your own instances.
             .
             Finally, there is a function that will raise an exception on
             bounds-checking violation, or return a bare value otherwise,
             implemented in terms of the safer function described above.
             .
             Convertible is also used by HDBC 2.0 for handling marshalling of
             data to and from databases.
             .
             Convertible is backed by an extensive test suite and passes tests
             on GHC and Hugs.
category: Data
author: John Goerzen
pkgpath: devel/hs-convertible
exposed: True
exposed-modules: Data.Convertible Data.Convertible.Base
                 Data.Convertible.Utils Data.Convertible.Instances
                 Data.Convertible.Instances.C Data.Convertible.Instances.Map
                 Data.Convertible.Instances.Num Data.Convertible.Instances.Text
                 Data.Convertible.Instances.Time
hidden-modules:
import-dirs: /usr/local/lib/ghc/convertible-1.0.10.0
library-dirs: /usr/local/lib/ghc/convertible-1.0.10.0
hs-libraries: HSconvertible-1.0.10.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         bytestring-0.9.1.10-2da7b519f76934c0e733bf92c23382ec
         containers-0.4.0.0-8781485edb2ac0db733a9f9c72e27945
         mtl-2.0.1.0-91f62d81c946aa60137dcc008e554a3a
         old-locale-1.0.0.2-cc522edd16b73a70b897598c5f5d20c7
         old-time-1.0.0.6-dfdb9c34ec39bc9a2a57345b38e135d4
         text-0.11.0.6-8c4af07195c37bf4d73ffb41fc92ea29
         time-1.2.0.3-4f1bed38bdf37d398ba8f4311cbdac4a
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.0.10.0/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.0.10.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
