#!/bin/sh
echo 'name: crypto-api
version: 0.6.1
id: crypto-api-0.6.1-441f8b227b136ba1febefb2d9e4c0949

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike) (see AUTHORS)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
description: A generic interface for cryptographic operations,
             platform independent quality RNG, property tests
             and known-answer tests (KATs) for common algorithms,
             and a basic benchmark infrastructure.
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Modes System.Crypto.Random Crypto.Random Crypto.Padding
hidden-modules: Crypto.Util Crypto.CPoly
import-dirs: /usr/local/lib/ghc/crypto-api-0.6.1
library-dirs: /usr/local/lib/ghc/crypto-api-0.6.1
hs-libraries: HScrypto-api-0.6.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         bytestring-0.9.1.10-2da7b519f76934c0e733bf92c23382ec
         cereal-0.3.0.0-ee33e7a9312912eef09d2af1b20190e8
         largeword-1.0.0-51321644574ac8da7a5c254f698d9e07
         tagged-0.2-7caf964ebb614f24b61729c6e1006b72
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.6.1/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.6.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
