#!/bin/sh
echo 'name: cryptohash
version: 0.7.0
id: cryptohash-0.7.0-cd789756474175c1e1b3528eaa48fc28

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability:
homepage: http://github.com/vincenthz/hs-cryptohash
package-url:
description: A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
             with performance close to the fastest implementations available in others languages.
             .
             The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cryptohash
exposed: True
exposed-modules: Crypto.Hash.SHA1 Crypto.Hash.SHA224
                 Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                 Crypto.Hash.SHA512t Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                 Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                 Crypto.Hash.Tiger
hidden-modules:
import-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
library-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
hs-libraries: HScryptohash-0.7.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         bytestring-0.9.1.10-2da7b519f76934c0e733bf92c23382ec
         cereal-0.3.0.0-ee33e7a9312912eef09d2af1b20190e8
         crypto-api-0.6.1-441f8b227b136ba1febefb2d9e4c0949
         tagged-0.2-7caf964ebb614f24b61729c6e1006b72
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.7.0/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.7.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
