#!/bin/sh
echo 'name: directory-tree
version: 0.2.0
id: directory-tree-0.2.0-145217ccc5bf3ca44803c4301eccb2f6

license: BSD3
copyright: (c) 2010, Brandon Simmons <brandon.m.simmons@gmail.com>
maintainer: Brandon Simmons <brandon.m.simmons@gmail.com>
stability:
homepage: http://coder.bsimmons.name/blog/2009/05/directory-tree-module-released/
package-url:
description: A simple directory-like tree datatype, with useful IO functions and Foldable and Traversable instance
             .
             Provides a simple data structure mirroring a directory tree on the
             filesystem, as well as useful functions for reading and writing
             file and directory structures in the IO monad.
             .
             Importing the library and optional (useful) Foldable and Traverable libraries:
             .
             > import System.Directory.Tree
             > import qualified Data.Foldable as F
             > import qualified Data.Traversable as T
             .
             Write a hand-made directory tree of textfiles (strings) to the disk.
             Simulates creating a new user Tux'\''s home directory on a unix machine:
             .
             > writeDirectory$ "/home" :/ Dir "Tux" [File "README" "Welcome!"]
             .
             "read" a directory by opening all the files at a filepath with readFile,
             returning an '\''AnchoredDirTree String'\'' (d2). Then check for any IO failures:
             .
             > do (base :/ d2) <- readDirectory "../parent_dir/dir2/"
             >    let failed = anyFailed d2
             >    if failed then ...
             .
             Use Foldable instance function to concat a directory '\''dir'\'' of text files into a
             single file under the same directory:
             .
             > do (b :/ dt) <- readDirectory dir
             >    let f = F.concat dt
             >    return$ b :/ File "ALL_TEXT" f
             .
             Open all the files in the current directory as lazy bytestrings, ignoring
             the base path in Anchored wrapper:
             .
             > import qualified Data.ByteString.Lazy as B
             > do (_ :/ dTree) <- readDirectoryWith B.readFile "./"
             .
             Please send me any comments, requests or bug reports
category: Data, System
author: Brandon Simmons
pkgpath: devel/hs-directory-tree
exposed: True
exposed-modules: System.Directory.Tree
hidden-modules:
import-dirs: /usr/local/lib/ghc/directory-tree-0.2.0
library-dirs: /usr/local/lib/ghc/directory-tree-0.2.0
hs-libraries: HSdirectory-tree-0.2.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         directory-1.1.0.0-9315160d2d0511510edc9d31fb968f3c
         filepath-1.2.0.0-b273467b63dd15270d77af61bc610112
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-directory-tree-0.2.0/html/directory-tree.haddock
haddock-html: /usr/local/share/doc/hs-directory-tree-0.2.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
