/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackagesScopesProvider
implements CustomScopesProvider {
    private NamedScope myProjectTestScope;
    private NamedScope myProjectProductionScope;
    private final Project myProject;

    public static PackagesScopesProvider getInstance(Project project) {
        for (CustomScopesProvider provider : (CustomScopesProvider[])Extensions.getExtensions((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)project)) {
            if (!(provider instanceof PackagesScopesProvider)) continue;
            return (PackagesScopesProvider)provider;
        }
        return null;
    }

    public PackagesScopesProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<NamedScope> getCustomScopes() {
        ArrayList<NamedScope> list = new ArrayList<NamedScope>();
        list.add(this.getProjectProductionScope());
        list.add(this.getProjectTestScope());
        ArrayList<NamedScope> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/analysis/PackagesScopesProvider.getCustomScopes must not return null");
        }
        return arrayList;
    }

    public NamedScope getProjectTestScope() {
        if (this.myProjectTestScope == null) {
            final ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            this.myProjectTestScope = new NamedScope(IdeBundle.message((String)"predefined.scope.tests.name", (Object[])new Object[0]), new PackageSet(){

                public boolean contains(PsiFile file, NamedScopesHolder holder) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    return file.getProject() == PackagesScopesProvider.this.myProject && virtualFile != null && index.isInTestSourceContent(virtualFile);
                }

                public PackageSet createCopy() {
                    return this;
                }

                public String getText() {
                    return "test:*..*";
                }

                public int getNodePriority() {
                    return 0;
                }
            });
        }
        return this.myProjectTestScope;
    }

    public NamedScope getProjectProductionScope() {
        if (this.myProjectProductionScope == null) {
            final ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            this.myProjectProductionScope = new NamedScope(IdeBundle.message((String)"predefined.scope.production.name", (Object[])new Object[0]), new PackageSet(){

                public boolean contains(PsiFile file, NamedScopesHolder holder) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    return file.getProject() == PackagesScopesProvider.this.myProject && virtualFile != null && !index.isInTestSourceContent(virtualFile) && !index.isInLibraryClasses(virtualFile) && !index.isInLibrarySource(virtualFile);
                }

                public PackageSet createCopy() {
                    return this;
                }

                public String getText() {
                    return "src:*..*";
                }

                public int getNodePriority() {
                    return 0;
                }
            });
        }
        return this.myProjectProductionScope;
    }
}

