/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import javax.swing.Icon;

public abstract class ColorAndFontDescription
extends TextAttributes
implements EditorSchemeAttributeDescriptor {
    private final String myName;
    private final String myGroup;
    private final String myType;
    private final Icon myIcon;
    private final String myToolTip;
    private final EditorColorsScheme myScheme;
    private boolean isForegroundChecked;
    private boolean isBackgroundChecked;
    private boolean isEffectsColorChecked;
    private boolean isErrorStripeChecked;

    public ColorAndFontDescription(String name, String group, String type, EditorColorsScheme scheme, Icon icon, String toolTip) {
        this.myName = name;
        this.myGroup = group;
        this.myType = type;
        this.myScheme = scheme;
        this.myIcon = icon;
        this.myToolTip = toolTip;
    }

    public String toString() {
        return this.myName;
    }

    @Override
    public String getGroup() {
        return this.myGroup;
    }

    @Override
    public String getType() {
        return this.myType;
    }

    @Override
    public EditorColorsScheme getScheme() {
        return this.myScheme;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getToolTip() {
        return this.myToolTip;
    }

    protected void initCheckedStatus() {
        this.isForegroundChecked = this.getExternalForeground() != null;
        this.isBackgroundChecked = this.getExternalBackground() != null;
        this.isErrorStripeChecked = this.getExternalErrorStripe() != null;
        this.isEffectsColorChecked = this.getExternalEffectColor() != null;
        super.setForegroundColor(this.getExternalForeground());
        super.setBackgroundColor(this.getExternalBackground());
        super.setEffectColor(this.getExternalEffectColor());
        super.setEffectType(this.getExternalEffectType());
        super.setErrorStripeColor(this.getExternalErrorStripe());
    }

    public abstract Color getExternalForeground();

    public abstract Color getExternalBackground();

    public abstract Color getExternalErrorStripe();

    public abstract Color getExternalEffectColor();

    public abstract EffectType getExternalEffectType();

    public abstract void setExternalForeground(Color var1);

    public abstract void setExternalBackground(Color var1);

    public abstract void setExternalErrorStripe(Color var1);

    public abstract void setExternalEffectColor(Color var1);

    public abstract void setExternalEffectType(EffectType var1);

    public final void setForegroundColor(Color col) {
        super.setForegroundColor(col);
        if (this.isForegroundChecked) {
            this.setExternalForeground(col);
        } else {
            this.setExternalForeground(null);
        }
    }

    public final void setBackgroundColor(Color col) {
        super.setBackgroundColor(col);
        if (this.isBackgroundChecked) {
            this.setExternalBackground(col);
        } else {
            this.setExternalBackground(null);
        }
    }

    public void setErrorStripeColor(Color color) {
        super.setErrorStripeColor(color);
        if (this.isErrorStripeChecked) {
            this.setExternalErrorStripe(color);
        } else {
            this.setExternalErrorStripe(null);
        }
    }

    public final void setEffectColor(Color col) {
        super.setEffectColor(col);
        if (this.isEffectsColorChecked) {
            this.setExternalEffectColor(col);
        } else {
            this.setExternalEffectColor(null);
        }
    }

    public final void setEffectType(EffectType effectType) {
        super.setEffectType(effectType);
        this.setExternalEffectType(effectType);
    }

    public boolean isForegroundChecked() {
        return this.isForegroundChecked;
    }

    public boolean isBackgroundChecked() {
        return this.isBackgroundChecked;
    }

    public boolean isErrorStripeChecked() {
        return this.isErrorStripeChecked;
    }

    public boolean isEffectsColorChecked() {
        return this.isEffectsColorChecked;
    }

    public final void setForegroundChecked(boolean val) {
        this.isForegroundChecked = val;
        this.setForegroundColor(this.getForegroundColor());
    }

    public final void setBackgroundChecked(boolean val) {
        this.isBackgroundChecked = val;
        this.setBackgroundColor(this.getBackgroundColor());
    }

    public final void setErrorStripeChecked(boolean val) {
        this.isErrorStripeChecked = val;
        this.setErrorStripeColor(this.getErrorStripeColor());
    }

    public final void setEffectsColorChecked(boolean val) {
        this.isEffectsColorChecked = val;
        this.setEffectColor(this.getEffectColor());
        this.setEffectType(this.getEffectType());
    }

    public abstract int getFontType();

    public abstract void setFontType(int var1);

    public boolean isFontEnabled() {
        return true;
    }

    public boolean isForegroundEnabled() {
        return true;
    }

    public boolean isBackgroundEnabled() {
        return true;
    }

    public boolean isErrorStripeEnabled() {
        return false;
    }

    public boolean isEffectsColorEnabled() {
        return true;
    }

    @Override
    public boolean isModified() {
        return false;
    }
}

