/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCodeInsightAction
extends CodeInsightAction {
    private final boolean myLookForInjectedEditor;

    protected BaseCodeInsightAction() {
        this(true);
    }

    protected BaseCodeInsightAction(boolean lookForInjectedEditor) {
        this.myLookForInjectedEditor = lookForInjectedEditor;
    }

    @Nullable
    protected Editor getEditor(@NotNull DataContext dataContext, @NotNull Project project) {
        if (dataContext == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/actions/BaseCodeInsightAction.getEditor must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/actions/BaseCodeInsightAction.getEditor must not be null");
        }
        Editor editor = this.getBaseEditor(dataContext, project);
        if (!this.myLookForInjectedEditor) {
            return editor;
        }
        return BaseCodeInsightAction.getInjectedEditor(project, editor);
    }

    public static Editor getInjectedEditor(@NotNull Project project, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/actions/BaseCodeInsightAction.getInjectedEditor must not be null");
        }
        return BaseCodeInsightAction.getInjectedEditor(project, editor, true);
    }

    public static Editor getInjectedEditor(@NotNull Project project, Editor editor, boolean commit) {
        PsiDocumentManager documentManager;
        PsiFile psiFile;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/actions/BaseCodeInsightAction.getInjectedEditor must not be null");
        }
        Editor injectedEditor = editor;
        if (editor != null && (psiFile = (documentManager = PsiDocumentManager.getInstance((Project)project)).getCachedPsiFile(editor.getDocument())) != null) {
            if (commit) {
                documentManager.commitAllDocuments();
            }
            injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
        }
        return injectedEditor;
    }

    @Nullable
    protected Editor getBaseEditor(DataContext dataContext, Project project) {
        return super.getEditor(dataContext, project);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Lookup activeLookup = LookupManager.getInstance(project).getActiveLookup();
        if (activeLookup != null) {
            presentation.setEnabled(this.isValidForLookup());
        } else {
            super.update(event);
        }
    }

    protected boolean isValidForLookup() {
        return false;
    }
}

