/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaDocCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaDocCompletionContributor");
    @NonNls
    private static final String VALUE_TAG = "value";
    @NonNls
    private static final String LINK_TAG = "link";

    public JavaDocCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement((IElementType)PsiDocToken.DOC_TAG_NAME), new TagChooser());
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().inside(PsiDocTagValue.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(true){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaDocCompletionContributor$1.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaDocCompletionContributor$1.addCompletions must not be null");
                }
                PsiElement position = parameters.getPosition();
                boolean isArg = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).accepts((Object)position);
                PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocTag.class);
                boolean onlyConstants = !isArg && tag != null && tag.getName().equals(JavaDocCompletionContributor.VALUE_TAG);
                PsiReference ref = position.getContainingFile().findReferenceAt(parameters.getOffset());
                if (ref instanceof PsiJavaReference) {
                    result.stopHere();
                    JavaCompletionProcessor processor = new JavaCompletionProcessor(position, TrueFilter.INSTANCE, false, null);
                    ((PsiJavaReference)ref).processVariants((PsiScopeProcessor)processor);
                    for (CompletionElement _item : processor.getResults()) {
                        PsiField field;
                        Object o;
                        LookupItem item = (LookupItem)LookupItemUtil.objectToLookupItem(_item.getElement());
                        if (onlyConstants && (!((o = item.getObject()) instanceof PsiField) || !(field = (PsiField)o).hasModifierProperty("static") || field.getInitializer() == null || JavaConstantExpressionEvaluator.computeConstantExpression(field.getInitializer(), false) == null)) continue;
                        item.putUserData(LookupItem.FORCE_SHOW_SIGNATURE_ATTR, Boolean.TRUE);
                        if (isArg) {
                            item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                        }
                        item.setInsertHandler(new MethodSignatureInsertHandler());
                        result.addElement((LookupElement)item);
                    }
                }
            }
        });
    }

    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        if (PsiJavaPatterns.psiElement((IElementType)PsiDocToken.DOC_COMMENT_DATA).accepts((Object)parameters.getPosition())) {
            return;
        }
        super.fillCompletionVariants(parameters, result);
    }

    private static class MethodSignatureInsertHandler
    implements InsertHandler<LookupItem> {
        private MethodSignatureInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupItem item) {
            int afterSharp;
            if (!(item.getObject() instanceof PsiMethod)) {
                return;
            }
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
            Editor editor = context.getEditor();
            PsiMethod method = (PsiMethod)item.getObject();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            StringBuffer buffer = new StringBuffer();
            CharSequence chars = editor.getDocument().getCharsSequence();
            int endOffset = editor.getCaretModel().getOffset();
            Project project = context.getProject();
            int signatureOffset = afterSharp = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)(endOffset - 1), (String)"#") + 1;
            PsiElement element = context.getFile().findElementAt(signatureOffset - 1);
            CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)element.getProject());
            PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
            if (context.getCompletionChar() == '\t') {
                PsiDocTagValue valueElement = tag.getValueElement();
                endOffset = valueElement.getTextRange().getEndOffset();
            }
            editor.getDocument().deleteString(afterSharp, endOffset);
            editor.getCaretModel().moveToOffset(signatureOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            buffer.append(method.getName() + "(");
            int afterParenth = afterSharp + buffer.length();
            for (int i = 0; i < parameters.length; ++i) {
                PsiType type = TypeConversionUtil.erasure((PsiType)parameters[i].getType());
                buffer.append(type.getCanonicalText());
                if (i >= parameters.length - 1) continue;
                buffer.append(",");
                if (!styleSettings.SPACE_AFTER_COMMA) continue;
                buffer.append(" ");
            }
            buffer.append(")");
            if (!(tag instanceof PsiInlineDocTag)) {
                buffer.append(" ");
            } else {
                int currentOffset = editor.getCaretModel().getOffset();
                if (chars.charAt(currentOffset) == '}') {
                    ++afterSharp;
                } else {
                    buffer.append("} ");
                }
            }
            String insertString = buffer.toString();
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)insertString);
            editor.getCaretModel().moveToOffset(afterSharp + buffer.length());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            MethodSignatureInsertHandler.shortenReferences(project, editor, context, afterParenth);
        }

        private static void shortenReferences(Project project, Editor editor, InsertionContext context, int offset) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement element = context.getFile().findElementAt(offset);
            PsiDocTagValue tagValue = (PsiDocTagValue)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTagValue.class);
            if (tagValue != null) {
                try {
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)tagValue);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        }
    }

    private static class InlineInsertHandler
    implements InsertHandler<LookupItem> {
        private InlineInsertHandler() {
        }

        public void handleInsert(InsertionContext context, LookupItem item) {
            if (context.getCompletionChar() == '\t') {
                int currentOffset;
                Project project = context.getProject();
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                Editor editor = context.getEditor();
                CaretModel caretModel = editor.getCaretModel();
                int offset = caretModel.getOffset();
                PsiElement element = context.getFile().findElementAt(offset - 1);
                PsiDocTag tag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
                for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
                    PsiDocToken token;
                    if (!(child instanceof PsiDocToken) || (token = (PsiDocToken)child).getTokenType() != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                    return;
                }
                String name = tag.getName();
                CharSequence chars = editor.getDocument().getCharsSequence();
                if (chars.charAt(currentOffset = caretModel.getOffset()) == '}') {
                    caretModel.moveToOffset(offset + 1);
                } else if (chars.charAt(currentOffset + 1) == '}' && chars.charAt(currentOffset) == ' ') {
                    caretModel.moveToOffset(offset + 2);
                } else if (name.equals(JavaDocCompletionContributor.LINK_TAG)) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" }");
                    caretModel.moveToOffset(offset + 1);
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    editor.getSelectionModel().removeSelection();
                } else {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}");
                    caretModel.moveToOffset(offset + 1);
                }
            }
        }
    }

    private static class TagChooser
    extends CompletionProvider<CompletionParameters> {
        private TagChooser() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            JavadocTagInfo[] infos;
            if (parameters == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaDocCompletionContributor$TagChooser.addCompletions must not be null");
            }
            if (result == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/JavaDocCompletionContributor$TagChooser.addCompletions must not be null");
            }
            ArrayList<String> ret = new ArrayList<String>();
            PsiElement position = parameters.getPosition();
            PsiDocComment comment = (PsiDocComment)PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocComment.class);
            PsiElement parent = comment.getContext();
            boolean isInline = position.getContext() instanceof PsiInlineDocTag;
            JavadocManager manager = JavaPsiFacade.getInstance((Project)position.getProject()).getJavadocManager();
            for (JavadocTagInfo info : infos = manager.getTagInfos(parent)) {
                if (info.getName().equals("noinspection") || isInline != info.isInline()) continue;
                ret.add(info.getName());
            }
            InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(position.getProject()).getInspectionProfile();
            InspectionProfileEntry inspectionTool = inspectionProfile.getInspectionTool("JavaDoc", position);
            JavaDocLocalInspection inspection = (JavaDocLocalInspection)((LocalInspectionToolWrapper)inspectionTool).getTool();
            StringTokenizer tokenizer = new StringTokenizer(inspection.myAdditionalJavadocTags, ", ");
            while (tokenizer.hasMoreTokens()) {
                ret.add(tokenizer.nextToken());
            }
            for (String s : ret) {
                LookupItem item = (LookupItem)LookupItemUtil.objectToLookupItem(s);
                if (isInline) {
                    item.setInsertHandler(new InlineInsertHandler());
                }
                result.addElement((LookupElement)item);
            }
        }

        public String toString() {
            return "javadoc-tag-chooser";
        }
    }
}

