/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateClassFromUsageBaseFix
extends BaseIntentionAction {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix");
    protected CreateClassKind myKind;
    private final SmartPsiElementPointer<PsiJavaCodeReferenceElement> myRefElement;

    public CreateClassFromUsageBaseFix(CreateClassKind kind, PsiJavaCodeReferenceElement refElement) {
        this.myKind = kind;
        this.myRefElement = SmartPointerManager.getInstance((Project)refElement.getProject()).createLazyPointer((PsiElement)refElement);
    }

    protected abstract String getText(String var1);

    private boolean isAvailableInContext(@NotNull PsiJavaCodeReferenceElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromUsageBaseFix.isAvailableInContext must not be null");
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiJavaCodeReferenceCodeFragment) {
            return true;
        }
        if (parent instanceof PsiTypeElement) {
            if (parent.getParent() instanceof PsiReferenceParameterList) {
                return true;
            }
            while (parent.getParent() instanceof PsiTypeElement) {
                parent = parent.getParent();
            }
            if (parent.getParent() instanceof PsiCodeFragment || parent.getParent() instanceof PsiVariable || parent.getParent() instanceof PsiMethod || parent.getParent() instanceof PsiClassObjectAccessExpression || parent.getParent() instanceof PsiTypeCastExpression || parent.getParent() instanceof PsiInstanceOfExpression && ((PsiInstanceOfExpression)parent.getParent()).getCheckType() == parent) {
                return true;
            }
        } else if (parent instanceof PsiReferenceList) {
            PsiMethod method;
            if (this.myKind == CreateClassKind.ENUM) {
                return false;
            }
            if (parent.getParent() instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)parent.getParent();
                if (psiClass.getExtendsList() == parent) {
                    if (this.myKind == CreateClassKind.CLASS && !psiClass.isInterface()) {
                        return true;
                    }
                    if (this.myKind == CreateClassKind.INTERFACE && psiClass.isInterface()) {
                        return true;
                    }
                }
                if (psiClass.getImplementsList() == parent && this.myKind == CreateClassKind.INTERFACE) {
                    return true;
                }
            } else if (parent.getParent() instanceof PsiMethod && (method = (PsiMethod)parent.getParent()).getThrowsList() == parent && this.myKind == CreateClassKind.CLASS) {
                return true;
            }
        } else if (parent instanceof PsiAnonymousClass && ((PsiAnonymousClass)parent).getBaseClassReference() == element) {
            return true;
        }
        if (element instanceof PsiReferenceExpression) {
            if (parent instanceof PsiMethodCallExpression) {
                return false;
            }
            return !(parent.getParent() instanceof PsiMethodCallExpression) || this.myKind == CreateClassKind.CLASS;
        }
        return false;
    }

    private static boolean checkClassName(String name) {
        return Character.isUpperCase(name.charAt(0));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromUsageBaseFix.isAvailable must not be null");
        }
        PsiJavaCodeReferenceElement element = this.getRefElement();
        if (element == null || !element.getManager().isInProject((PsiElement)element) || CreateFromUsageUtils.isValidReference((PsiReference)element, true)) {
            return false;
        }
        String refName = element.getReferenceName();
        if (refName == null || !CreateClassFromUsageBaseFix.checkClassName(refName)) {
            return false;
        }
        PsiElement nameElement = element.getReferenceNameElement();
        if (nameElement == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpression && !(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        if (!this.isAvailableInContext(element)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (CreateFromUsageUtils.shouldShowTag(offset, nameElement, (PsiElement)element)) {
            this.setText(this.getText(nameElement.getText()));
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.class.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromUsageBaseFix.getFamilyName must not return null");
        }
        return string;
    }

    @Nullable
    protected PsiJavaCodeReferenceElement getRefElement() {
        return (PsiJavaCodeReferenceElement)this.myRefElement.getElement();
    }

    @Nullable
    protected static String getSuperClassName(PsiJavaCodeReferenceElement element) {
        PsiMethod method;
        String superClassName = element.getParent().getParent() instanceof PsiMethod ? ((method = (PsiMethod)element.getParent().getParent()).getThrowsList() == element.getParent() ? "java.lang.Exception" : null) : null;
        return superClassName;
    }
}

