/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CreateParameterFromUsageFix
extends CreateVarFromUsageFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateParameterFromUsageFix");

    public CreateParameterFromUsageFix(PsiReferenceExpression referenceElement) {
        super(referenceElement);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        if (this.myReferenceExpression.isQualified()) {
            return false;
        }
        PsiReferenceExpression scope = this.myReferenceExpression;
        while ((scope = PsiTreeUtil.getParentOfType((PsiElement)scope, (Class[])new Class[]{PsiMethod.class, PsiClass.class})) instanceof PsiAnonymousClass) {
        }
        return scope instanceof PsiMethod && ((PsiMethod)scope).getParameterList().isPhysical();
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.parameter.from.usage.text", varName);
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        if (CreateFromUsageUtils.isValidReference((PsiReference)this.myReferenceExpression, true)) {
            return;
        }
        Project project = this.myReferenceExpression.getProject();
        PsiType[] expectedTypes = CreateFromUsageUtils.guessType((PsiExpression)this.myReferenceExpression, false);
        PsiType type = expectedTypes[0];
        String varName = this.myReferenceExpression.getReferenceName();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myReferenceExpression, PsiMethod.class);
        LOG.assertTrue(method != null);
        method = IntroduceParameterHandler.chooseEnclosingMethod(method);
        if (method == null) {
            return;
        }
        if ((method = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"))) == null) {
            return;
        }
        ArrayList<ParameterInfoImpl> parameterInfos = new ArrayList<ParameterInfoImpl>(Arrays.asList(ParameterInfoImpl.fromMethod(method)));
        ParameterInfoImpl parameterInfo = new ParameterInfoImpl(-1, varName, type, PsiTypesUtil.getDefaultValueOfType((PsiType)type), false);
        parameterInfos.add(parameterInfo);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ParameterInfoImpl[] array = parameterInfos.toArray(new ParameterInfoImpl[parameterInfos.size()]);
            String modifier = PsiUtil.getAccessModifier((int)PsiUtil.getAccessLevel((PsiModifierList)method.getModifierList()));
            ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, modifier, method.getName(), method.getReturnType(), array);
            processor.run();
        } else {
            ChangeSignatureDialog dialog = new ChangeSignatureDialog(project, method, false, this.myReferenceExpression);
            dialog.setParameterInfos(parameterInfos);
            dialog.show();
        }
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.parameter.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/CreateParameterFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }
}

