/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.javaee.ExternalResourceManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.GuiUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetchExtResourceAction
extends BaseExtResourceAction
implements WatchedRootsProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.FetchDtdAction");
    @NonNls
    private static final String HTML_MIME = "text/html";
    @NonNls
    private static final String HTTP_PROTOCOL = "http://";
    @NonNls
    private static final String HTTPS_PROTOCOL = "https://";
    @NonNls
    private static final String FTP_PROTOCOL = "ftp://";
    @NonNls
    private static final String EXT_RESOURCES_FOLDER = "extResources";

    @Override
    protected String getQuickFixKeyId() {
        return "fetch.external.resource";
    }

    @Override
    protected boolean isAcceptableUri(String uri) {
        return uri.startsWith(HTTP_PROTOCOL) || uri.startsWith(FTP_PROTOCOL) || uri.startsWith(HTTPS_PROTOCOL);
    }

    public static String findUrl(PsiFile file, int offset, String uri) {
        String attrValue;
        String prefix;
        XmlTag tag;
        PsiElement currentElement = file.findElementAt(offset);
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlAttribute.class);
        if (attribute != null && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class)) != null && (prefix = tag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) != null && (attrValue = tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(attrValue);
            while (tokenizer.hasMoreElements()) {
                if (uri.equals(tokenizer.nextToken())) {
                    if (!tokenizer.hasMoreElements()) {
                        return uri;
                    }
                    String url = tokenizer.nextToken();
                    return url.startsWith(HTTP_PROTOCOL) ? url : uri;
                }
                if (!tokenizer.hasMoreElements()) {
                    return uri;
                }
                tokenizer.nextToken();
            }
        }
        return uri;
    }

    @NotNull
    public Set<String> getRootsToWatch() {
        Set<String> set = Collections.singleton(FetchExtResourceAction.getExternalResourcesPath());
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/FetchExtResourceAction.getRootsToWatch must not return null");
        }
        return set;
    }

    @Override
    protected void doInvoke(PsiFile file, int offset, final String uri, Editor editor) throws IncorrectOperationException {
        final String url = FetchExtResourceAction.findUrl(file, offset, uri);
        final Project project = file.getProject();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            final ProgressWindow[] result = new ProgressWindow[1];
                            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ProgressWindow progressWindow = new ProgressWindow(true, project);
                                    progressWindow.setTitle(XmlBundle.message((String)"fetching.resource.title", (Object[])new Object[0]));
                                    result[0] = progressWindow;
                                }
                            }, ModalityState.defaultModalityState());
                            ProgressManager.getInstance().runProcess(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        HttpConfigurable.getInstance().prepareURL(url);
                                        FetchExtResourceAction.this.fetchDtd(project, uri, url);
                                    }
                                    catch (IOException ex) {
                                        FetchingResourceIOException exceptionDescribingIOProblem = ex instanceof FetchingResourceIOException ? (FetchingResourceIOException)ex : new FetchingResourceIOException(ex, url);
                                        throw new FetchingResourceProblemRuntimeWrapper(exceptionDescribingIOProblem);
                                    }
                                }
                            }, (ProgressIndicator)result[0]);
                        }
                        catch (FetchingResourceProblemRuntimeWrapper e) {
                            String message = XmlBundle.message((String)"error.fetching.title", (Object[])new Object[0]);
                            FetchingResourceIOException ioproblem = (FetchingResourceIOException)e.getCause();
                            if (!url.equals(ioproblem.url)) {
                                message = XmlBundle.message((String)"error.fetching.dependent.resource.title", (Object[])new Object[0]);
                            }
                            IOException cause = (IOException)ioproblem.getCause();
                            LOG.info((Throwable)cause);
                            if (IOExceptionDialog.showErrorDialog((String)message, (String)XmlBundle.message((String)"error.fetching.resource", (Object[])new Object[]{ioproblem.url}))) continue;
                        }
                        break;
                    }
                }
            });
        }
    }

    private void fetchDtd(final Project project, final String dtdUrl, final String url) throws IOException {
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        final String extResourcesPath = FetchExtResourceAction.getExternalResourcesPath();
        final File extResources = new File(extResourcesPath);
        final boolean alreadyExists = extResources.exists();
        extResources.mkdirs();
        LOG.assertTrue(extResources.exists());
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(extResources.getAbsolutePath().replace(File.separatorChar, '/'));
                        LOG.assertTrue(vFile != null);
                        PsiDirectory directory = psiManager.findDirectory(vFile);
                        directory.getFiles();
                        if (!alreadyExists) {
                            LocalFileSystem.getInstance().addRootToWatch(vFile.getPath(), true);
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }, indicator.getModalityState());
        final LinkedList<String> downloadedResources = new LinkedList<String>();
        final LinkedList<String> resourceUrls = new LinkedList<String>();
        final IOException[] nestedException = new IOException[1];
        try {
            final String resPath = FetchExtResourceAction.fetchOneFile(indicator, url, project, extResourcesPath, null);
            if (resPath == null) {
                return;
            }
            resourceUrls.add(dtdUrl);
            downloadedResources.add(resPath);
            ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            ExternalResourceManagerImpl.getInstance().addResource(dtdUrl, resPath);
                            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(resPath.replace(File.separatorChar, '/'));
                            HashSet<String> linksToProcess = new HashSet<String>();
                            HashSet<String> processedLinks = new HashSet<String>();
                            HashMap<String, String> baseUrls = new HashMap<String, String>();
                            VirtualFile contextFile = virtualFile;
                            linksToProcess.addAll(FetchExtResourceAction.extractEmbeddedFileReferences(virtualFile, null, psiManager));
                            while (!linksToProcess.isEmpty()) {
                                String resourcePath;
                                String resourceUrl;
                                String s = (String)linksToProcess.iterator().next();
                                linksToProcess.remove(s);
                                processedLinks.add(s);
                                boolean absoluteUrl = s.startsWith(FetchExtResourceAction.HTTP_PROTOCOL);
                                if (absoluteUrl) {
                                    resourceUrl = s;
                                } else {
                                    String baseUrl = (String)baseUrls.get(s);
                                    if (baseUrl == null) {
                                        baseUrl = url;
                                    }
                                    resourceUrl = baseUrl.substring(0, baseUrl.lastIndexOf(47) + 1) + s;
                                }
                                String refname = s.substring(s.lastIndexOf(47) + 1);
                                if (absoluteUrl) {
                                    refname = Integer.toHexString(s.hashCode()) + "_" + refname;
                                }
                                try {
                                    resourcePath = FetchExtResourceAction.fetchOneFile(indicator, resourceUrl, project, extResourcesPath, refname);
                                }
                                catch (IOException e) {
                                    nestedException[0] = new FetchingResourceIOException(e, resourceUrl);
                                    break;
                                }
                                if (resourcePath == null) break;
                                virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(resourcePath.replace(File.separatorChar, '/'));
                                downloadedResources.add(resourcePath);
                                if (absoluteUrl) {
                                    ExternalResourceManagerImpl.getInstance().addResource(s, resourcePath);
                                    resourceUrls.add(s);
                                }
                                List<String> newLinks = FetchExtResourceAction.extractEmbeddedFileReferences(virtualFile, contextFile, psiManager);
                                for (String u : newLinks) {
                                    baseUrls.put(u, resourceUrl);
                                    if (processedLinks.contains(u)) continue;
                                    linksToProcess.add(u);
                                }
                            }
                        }
                    });
                }
            }, indicator.getModalityState());
        }
        catch (IOException ex) {
            nestedException[0] = ex;
        }
        if (nestedException[0] != null) {
            this.cleanup(resourceUrls, downloadedResources);
            throw nestedException[0];
        }
    }

    public static String getExternalResourcesPath() {
        return PathManager.getSystemPath() + File.separator + EXT_RESOURCES_FOLDER;
    }

    private void cleanup(final List<String> resourceUrls, final List<String> downloadedResources) {
        try {
            GuiUtils.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            for (String resourcesUrl : resourceUrls) {
                                ExternalResourceManagerImpl.getInstance().removeResource(resourcesUrl);
                            }
                            for (String downloadedResource : downloadedResources) {
                                try {
                                    LocalFileSystem.getInstance().findFileByIoFile(new File(downloadedResource)).delete((Object)this);
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    });
                }
            });
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String fetchOneFile(final ProgressIndicator indicator, final String resourceUrl, final Project project, String extResourcesPath, String refname) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                indicator.setText(XmlBundle.message((String)"fetching.progress.indicator", (Object[])new Object[]{resourceUrl}));
            }
        });
        FetchResult result = FetchExtResourceAction.fetchData(project, resourceUrl, indicator);
        if (result == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && result.contentType != null && result.contentType.indexOf(HTML_MIME) != -1 && new String(result.bytes).indexOf("<html") != -1) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showMessageDialog((Project)project, (String)XmlBundle.message((String)"invalid.url.no.xml.file.at.location", (Object[])new Object[]{resourceUrl}), (String)XmlBundle.message((String)"invalid.url.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                }
            }, indicator.getModalityState());
            return null;
        }
        int slashIndex = resourceUrl.lastIndexOf(47);
        String resPath = extResourcesPath + File.separatorChar;
        if (refname != null) {
            int refnameSlashIndex = (resPath = resPath + refname).lastIndexOf(47);
            if (refnameSlashIndex != -1) {
                new File(resPath.substring(0, refnameSlashIndex)).mkdirs();
            }
        } else {
            resPath = resPath + Integer.toHexString(resourceUrl.hashCode()) + "_" + resourceUrl.substring(slashIndex + 1);
        }
        int lastDoPosInResourceUrl = resourceUrl.lastIndexOf(46, slashIndex);
        if (lastDoPosInResourceUrl == -1 || FileTypeManager.getInstance().getFileTypeByExtension(resourceUrl.substring(lastDoPosInResourceUrl + 1)) == StdFileTypes.UNKNOWN) {
            resPath = resPath + "." + StdFileTypes.XML.getDefaultExtension();
        }
        File res = new File(resPath);
        FileOutputStream out = new FileOutputStream(res);
        try {
            out.write(result.bytes);
        }
        finally {
            out.close();
        }
        return resPath;
    }

    private static List<String> extractEmbeddedFileReferences(XmlFile file, XmlFile context) {
        final LinkedList<String> result = new LinkedList<String>();
        if (context != null) {
            XmlEntityRefImpl.copyEntityCaches((PsiFile)file, (PsiFile)context);
        }
        XmlUtil.processXmlElements((XmlElement)file, new PsiElementProcessor(){

            public boolean execute(PsiElement element) {
                if (element instanceof XmlEntityDecl) {
                    String candidateName = null;
                    for (PsiElement e = element.getLastChild(); e != null; e = e.getPrevSibling()) {
                        if (e instanceof XmlAttributeValue && candidateName == null) {
                            candidateName = e.getText().substring(1, e.getTextLength() - 1);
                            continue;
                        }
                        if (!(e instanceof XmlToken) || candidateName == null || ((XmlToken)e).getTokenType() != XmlTokenType.XML_DOCTYPE_PUBLIC) continue;
                        if (result.contains(candidateName)) break;
                        result.add(candidateName);
                        break;
                    }
                } else if (element instanceof XmlTag) {
                    String prefix;
                    PsiReference[] references;
                    XmlTag tag = (XmlTag)element;
                    String schemaLocation = tag.getAttributeValue("schemaLocation");
                    if (schemaLocation != null && (references = tag.getAttribute("schemaLocation", null).getValueElement().getReferences()).length > 0) {
                        String namespace = tag.getAttributeValue("namespace");
                        if (namespace != null && schemaLocation.indexOf(47) == -1) {
                            result.add(namespace.substring(0, namespace.lastIndexOf(47) + 1) + schemaLocation);
                        } else {
                            result.add(schemaLocation);
                        }
                    }
                    if ((prefix = tag.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema-instance")) != null && (schemaLocation = tag.getAttributeValue("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance")) != null) {
                        StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
                        while (tokenizer.hasMoreTokens()) {
                            tokenizer.nextToken();
                            if (tokenizer.hasMoreTokens()) {
                                String location = tokenizer.nextToken();
                                if (result.contains(location)) continue;
                                result.add(location);
                                continue;
                            }
                            break;
                        }
                    }
                }
                return true;
            }
        }, true, true);
        return result;
    }

    public static List<String> extractEmbeddedFileReferences(VirtualFile vFile, VirtualFile contextVFile, PsiManager psiManager) {
        PsiFile file = psiManager.findFile(vFile);
        if (file instanceof XmlFile) {
            PsiFile contextFile = contextVFile != null ? psiManager.findFile(contextVFile) : null;
            return FetchExtResourceAction.extractEmbeddedFileReferences((XmlFile)file, contextFile instanceof XmlFile ? (XmlFile)contextFile : null);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static FetchResult fetchData(final Project project, final String dtdUrl, ProgressIndicator indicator) throws IOException {
        try {
            int read;
            URL url = new URL(dtdUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.addRequestProperty("accept", "text/xml,application/xml,text/html,*/*");
            int contentLength = urlConnection.getContentLength();
            int bytesRead = 0;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream in = urlConnection.getInputStream();
            String contentType = urlConnection.getContentType();
            byte[] buffer = new byte[256];
            while ((read = in.read(buffer)) >= 0) {
                out.write(buffer, 0, read);
                indicator.setFraction((double)(bytesRead += read) / (double)contentLength);
            }
            in.close();
            out.close();
            FetchResult result = new FetchResult();
            result.bytes = out.toByteArray();
            result.contentType = contentType;
            return result;
        }
        catch (MalformedURLException e) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showMessageDialog((Project)project, (String)XmlBundle.message((String)"invalid.uril.message", (Object[])new Object[]{dtdUrl}), (String)XmlBundle.message((String)"invalid.url.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                    }
                }, indicator.getModalityState());
            }
            return null;
        }
    }

    static class FetchResult {
        byte[] bytes;
        String contentType;

        FetchResult() {
        }
    }

    static class FetchingResourceProblemRuntimeWrapper
    extends RuntimeException {
        FetchingResourceProblemRuntimeWrapper(FetchingResourceIOException cause) {
            super(cause);
        }
    }

    static class FetchingResourceIOException
    extends IOException {
        private final String url;

        FetchingResourceIOException(Throwable cause, String url) {
            this.initCause(cause);
            this.url = url;
        }
    }
}

