/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportClassFixBase<T extends PsiElement & PsiReference>
implements HintAction {
    private final T myRef;

    protected ImportClassFixBase(T ref) {
        this.myRef = ref;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase.isAvailable must not be null");
        }
        return this.myRef.isValid() && file.getManager().isInProject((PsiElement)file) && !this.getClassesToImport().isEmpty();
    }

    @Nullable
    protected abstract String getReferenceName(T var1);

    protected abstract boolean hasTypeParameters(T var1);

    public List<PsiClass> getClassesToImport() {
        PsiManager manager = PsiManager.getInstance((Project)this.myRef.getProject());
        PsiShortNamesCache cache = JavaPsiFacade.getInstance((Project)manager.getProject()).getShortNamesCache();
        String name = this.getReferenceName(this.myRef);
        GlobalSearchScope scope = this.myRef.getResolveScope();
        if (name == null) {
            return Collections.emptyList();
        }
        boolean referenceHasTypeParameters = this.hasTypeParameters(this.myRef);
        PsiClass[] classes = cache.getClassesByName(name, scope);
        if (classes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> classList = new ArrayList<PsiClass>(classes.length);
        boolean isAnnotationReference = this.myRef.getParent() instanceof PsiAnnotation;
        for (PsiClass aClass : classes) {
            String qName;
            if (isAnnotationReference && !aClass.isAnnotationType() || JavaCompletionUtil.isInExcludedPackage(aClass) || referenceHasTypeParameters && !aClass.hasTypeParameters() || (qName = aClass.getQualifiedName()) == null || qName.indexOf(46) == -1 || !qName.endsWith(name) || !this.isAccessible(aClass, this.myRef)) continue;
            classList.add(aClass);
        }
        return classList;
    }

    protected abstract boolean isAccessible(PsiClass var1, T var2);

    protected abstract String getQualifiedName(T var1);

    public Result doFix(@NotNull Editor editor, boolean doShow, boolean allowCaretNearRef) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase.doFix must not be null");
        }
        List<PsiClass> classesToImport = this.getClassesToImport();
        if (classesToImport.isEmpty()) {
            return Result.POPUP_NOT_SHOWN;
        }
        try {
            Pattern pattern;
            Matcher matcher;
            String name = this.getQualifiedName(this.myRef);
            if (name != null && (matcher = (pattern = Pattern.compile(DaemonCodeAnalyzerSettings.getInstance().NO_AUTO_IMPORT_PATTERN)).matcher(name)).matches()) {
                return Result.POPUP_NOT_SHOWN;
            }
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
        PsiFile psiFile = this.myRef.getContainingFile();
        if (classesToImport.size() > 1) {
            ImportClassFixBase.reduceSuggestedClassesBasedOnDependencyRuleViolation(psiFile, classesToImport);
        }
        PsiClass[] classes = classesToImport.toArray(new PsiClass[classesToImport.size()]);
        Project project = this.myRef.getProject();
        CodeInsightUtil.sortIdenticalShortNameClasses(classes, (PsiElement)psiFile);
        final AddImportAction action = this.createAddImportAction(classes, project, editor);
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        boolean canImportHere = true;
        if (classes.length == 1 && (canImportHere = this.canImportHere(allowCaretNearRef, editor, psiFile, classes[0].getName())) && (JspPsiUtil.isInJspFile((PsiElement)psiFile) ? CodeInsightSettings.getInstance().JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY : CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY) && codeAnalyzer.canChangeFileSilently((PsiFileSystemItem)psiFile)) {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    action.execute();
                }
            });
            return Result.CLASS_IMPORTED;
        }
        if (doShow && canImportHere) {
            String hintText = ShowAutoImportPass.getMessage(classes.length > 1, classes[0].getQualifiedName());
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showQuestionHint(editor, hintText, this.myRef.getTextOffset(), this.myRef.getTextRange().getEndOffset(), (QuestionAction)action);
            }
            return Result.POPUP_SHOWN;
        }
        return Result.POPUP_NOT_SHOWN;
    }

    private boolean canImportHere(boolean allowCaretNearRef, Editor editor, PsiFile psiFile, String exampleClassName) {
        return (allowCaretNearRef || !ImportClassFixBase.isCaretNearRef(editor, this.myRef)) && !this.hasUnresolvedImportWhichCanImport(psiFile, exampleClassName);
    }

    protected abstract boolean isQualified(T var1);

    public boolean showHint(Editor editor) {
        if (this.isQualified(this.myRef)) {
            return false;
        }
        Result result = this.doFix(editor, true, false);
        return result == Result.POPUP_SHOWN || result == Result.CLASS_IMPORTED;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("import.class.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("import.class.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase.getFamilyName must not return null");
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean hasUnresolvedImportWhichCanImport(PsiFile var1, String var2);

    private static void reduceSuggestedClassesBasedOnDependencyRuleViolation(PsiFile file, List<PsiClass> availableClasses) {
        Project project = file.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project);
        for (int i = availableClasses.size() - 1; i >= 0; --i) {
            DependencyRule[] violated;
            PsiClass psiClass = availableClasses.get(i);
            PsiFile targetFile = psiClass.getContainingFile();
            if (targetFile == null || (violated = validationManager.getViolatorDependencyRules(file, targetFile)).length == 0) continue;
            availableClasses.remove(i);
            if (availableClasses.size() == 1) break;
        }
    }

    private static boolean isCaretNearRef(Editor editor, PsiElement ref) {
        TextRange range = ref.getTextRange();
        int offset = editor.getCaretModel().getOffset();
        return offset == range.getEndOffset();
    }

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ImportClassFixBase.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                List<PsiClass> classesToImport = ImportClassFixBase.this.getClassesToImport();
                PsiClass[] classes = classesToImport.toArray(new PsiClass[classesToImport.size()]);
                CodeInsightUtil.sortIdenticalShortNameClasses(classes, (PsiElement)file);
                if (classes.length == 0) {
                    return;
                }
                AddImportAction action = ImportClassFixBase.this.createAddImportAction(classes, project, editor);
                action.execute();
            }
        });
    }

    protected void bindReference(T reference, PsiClass targetClass) {
        ((PsiReference)reference).bindToElement((PsiElement)targetClass);
    }

    protected AddImportAction createAddImportAction(PsiClass[] classes, Project project, Editor editor) {
        return new AddImportAction(project, (PsiReference)this.myRef, editor, classes){

            @Override
            protected void bindReference(PsiReference ref, PsiClass targetClass) {
                ImportClassFixBase.this.bindReference((PsiElement)ref, targetClass);
            }
        };
    }

    public static enum Result {
        POPUP_SHOWN,
        CLASS_IMPORTED,
        POPUP_NOT_SHOWN;

    }
}

