/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;

public class LineTooltipRenderer
implements TooltipRenderer {
    @NonNls
    protected String myText;
    private boolean myActiveLink = false;
    private int myCurrentWidth;
    @NonNls
    protected static final String BORDER_LINE = "<hr size=1 noshade>";

    public LineTooltipRenderer(String text) {
        this.myText = text;
    }

    public LineTooltipRenderer(String text, int width) {
        this(text);
        this.myCurrentWidth = width;
    }

    @Override
    public LightweightHint show(final Editor editor, final Point p, boolean alignToRight, final TooltipGroup group) {
        int height;
        if (this.myText == null) {
            return null;
        }
        this.myText = this.myText.replaceAll(String.valueOf('\u001b'), "");
        final boolean expanded = this.myCurrentWidth > 0 && this.dressDescription(editor);
        final JEditorPane pane = LineTooltipRenderer.initPane(this.myText);
        pane.setCaretPosition(0);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        final JComponent contentComponent = editor.getContentComponent();
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        int widthLimit = layeredPane.getWidth() - 10;
        int heightLimit = layeredPane.getHeight() - 5;
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)pane);
        scrollPane.setBorder(null);
        int width = expanded ? 3 * this.myCurrentWidth / 2 : pane.getPreferredSize().width;
        int n = height = expanded ? Math.max(pane.getPreferredSize().height, 150) : pane.getPreferredSize().height;
        if (alignToRight) {
            p.x -= width;
        }
        p.x += 3;
        p.y += 3;
        if (p.x + width >= widthLimit) {
            p.x = widthLimit - width;
            width = Math.min(width, widthLimit);
            height += 20;
        }
        if (p.x < 3) {
            p.x = 3;
        }
        if (p.y + height > heightLimit) {
            p.y = heightLimit - height;
            height = Math.min(heightLimit, height);
        }
        if (p.y < 3) {
            p.y = 3;
        }
        pane.setSize(width, height);
        pane.setMaximumSize(new Dimension(width, height));
        pane.setMinimumSize(new Dimension(width, height));
        pane.setPreferredSize(new Dimension(width, height));
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        final Ref anAction = new Ref();
        final LightweightHint hint = new LightweightHint(scrollPane){

            @Override
            public void hide() {
                LineTooltipRenderer.this.onHide(pane);
                super.hide();
                AnAction action = (AnAction)anAction.get();
                if (action != null) {
                    action.unregisterCustomShortcutSet(contentComponent);
                }
            }
        };
        anAction.set((Object)new AnAction(){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ShowErrorDescription")), contentComponent);
            }

            public void actionPerformed(AnActionEvent e) {
                hint.hide();
                if (LineTooltipRenderer.this.myCurrentWidth > 0) {
                    LineTooltipRenderer.this.stripDescription();
                }
                LineTooltipRenderer.this.createRenderer(LineTooltipRenderer.this.myText, LineTooltipRenderer.this.myCurrentWidth > 0 ? 0 : pane.getWidth()).show(editor, new Point(p.x - 3, p.y - 3), false, group);
            }
        });
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                LineTooltipRenderer.this.myActiveLink = true;
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    LineTooltipRenderer.this.myActiveLink = false;
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (!expanded) {
                        for (TooltipLinkHandlerEP handlerEP : (TooltipLinkHandlerEP[])Extensions.getExtensions(TooltipLinkHandlerEP.EP_NAME)) {
                            if (!handlerEP.handleLink(e.getDescription(), editor, pane)) continue;
                            LineTooltipRenderer.this.myText = LineTooltipRenderer.this.convertTextOnLinkHandled(LineTooltipRenderer.this.myText);
                            pane.setText(LineTooltipRenderer.this.myText);
                            return;
                        }
                        if (e.getURL() != null) {
                            BrowserUtil.launchBrowser((String)e.getURL().toString());
                        }
                    } else {
                        if (e.getURL() != null) {
                            BrowserUtil.launchBrowser((String)e.getURL().toString());
                            return;
                        }
                        LineTooltipRenderer.this.stripDescription();
                        hint.hide();
                        LineTooltipRenderer.this.createRenderer(LineTooltipRenderer.this.myText, 0).show(editor, new Point(p.x - 3, p.y - 3), false, group);
                    }
                }
            }
        });
        pane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!LineTooltipRenderer.this.myActiveLink) {
                    MouseEvent newMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, contentComponent);
                    hint.hide();
                    contentComponent.dispatchEvent(newMouseEvent);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!expanded) {
                    hint.hide();
                }
            }
        });
        hintManager.showEditorHint(hint, editor, p, 58, 0, false);
        return hint;
    }

    protected String convertTextOnLinkHandled(String text) {
        return text;
    }

    protected void onHide(JComponent contentComponent) {
    }

    protected LineTooltipRenderer createRenderer(String text, int width) {
        return new LineTooltipRenderer(text, width);
    }

    protected boolean dressDescription(Editor editor) {
        return false;
    }

    protected void stripDescription() {
    }

    static JEditorPane initPane(@NonNls String text) {
        text = "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + LineTooltipRenderer.getHtmlBody(text) + "</body></html>";
        JEditorPane pane = new JEditorPane("text/html", text);
        pane.setEditable(false);
        pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        pane.setForeground(Color.black);
        pane.setBackground(HintUtil.INFORMATION_COLOR);
        pane.setOpaque(true);
        return pane;
    }

    public void addBelow(String text) {
        String newBody;
        if (this.myText == null) {
            newBody = LineTooltipRenderer.getHtmlBody(text);
        } else {
            String html1 = LineTooltipRenderer.getHtmlBody(this.myText);
            String html2 = LineTooltipRenderer.getHtmlBody(text);
            newBody = html1 + BORDER_LINE + html2;
        }
        this.myText = "<html><body>" + newBody + "</body></html>";
    }

    protected static String getHtmlBody(@NonNls String text) {
        if (!text.startsWith("<html>")) {
            return text.replaceAll("\n", "<br>");
        }
        int bodyIdx = text.indexOf("<body>");
        int closedBodyIdx = text.indexOf("</body>");
        if (bodyIdx != -1 && closedBodyIdx != -1) {
            return text.substring(bodyIdx + "<body>".length(), closedBodyIdx);
        }
        text = StringUtil.trimStart((String)text, (String)"<html>").trim();
        text = StringUtil.trimEnd((String)text, (String)"</html>").trim();
        text = StringUtil.trimStart((String)text, (String)"<body>").trim();
        text = StringUtil.trimEnd((String)text, (String)"</body>").trim();
        return text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineTooltipRenderer)) {
            return false;
        }
        LineTooltipRenderer lineTooltipRenderer = (LineTooltipRenderer)o;
        return this.myText == null ? lineTooltipRenderer.myText == null : this.myText.equals(lineTooltipRenderer.myText);
    }

    public int hashCode() {
        return this.myText != null ? this.myText.hashCode() : 0;
    }

    public String getText() {
        return this.myText;
    }
}

