/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class MethodDownHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int[] offsets;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/navigation/MethodDownHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/navigation/MethodDownHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/navigation/MethodDownHandler.invoke must not be null");
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int caretOffset = editor.getCaretModel().getOffset();
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (int offset : offsets = MethodUpDownUtil.getNavigationOffsets(file, caretOffset)) {
            int line;
            if (offset <= caretOffset || (line = editor.offsetToLogicalPosition((int)offset).line) <= caretLine) continue;
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            break;
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

