/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateInvokationListener;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Set;

public class WrapWithCustomTemplateAction
extends AnAction {
    private final CustomLiveTemplate myTemplate;
    private final Editor myEditor;
    private final PsiFile myFile;

    public WrapWithCustomTemplateAction(CustomLiveTemplate template, Editor editor, PsiFile file, Set<Character> usedMnemonicsSet) {
        super(InvokeTemplateAction.extractMnemonic(template.getTitle(), usedMnemonicsSet));
        this.myTemplate = template;
        this.myFile = file;
        this.myEditor = editor;
    }

    public void actionPerformed(AnActionEvent e) {
        String selection;
        Document document = this.myEditor.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file != null) {
            ReadonlyStatusHandler.getInstance((Project)this.myFile.getProject()).ensureFilesWritable(new VirtualFile[]{file});
        }
        if ((selection = this.myEditor.getSelectionModel().getSelectedText()) != null) {
            selection = selection.trim();
            final CustomTemplateCallback callback = new CustomTemplateCallback(this.myEditor, this.myFile);
            this.myTemplate.wrap(selection, callback, new TemplateInvokationListener(){

                @Override
                public void finished() {
                    callback.startAllExpandedTemplates();
                }
            });
        }
    }
}

