/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class RightSideTypeMacro
implements Macro {
    public String getName() {
        return "rightSideType";
    }

    public String getDescription() {
        return CodeInsightBundle.message((String)"macro.right.side.type", (Object[])new Object[0]);
    }

    public String getDefaultValue() {
        return "A";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/RightSideTypeMacro.calculateResult must not be null");
        }
        int offset = context.getStartOffset();
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file.findElementAt(offset);
        element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiAssignmentExpression.class, PsiVariable.class});
        if (element instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
            PsiExpression rhs = assignment.getRExpression();
            if (rhs == null) {
                return null;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return null;
            }
            return new PsiTypeResult(rhsType, project);
        }
        if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            PsiExpression initializer = var.getInitializer();
            if (initializer == null) {
                return null;
            }
            PsiType type = RefactoringUtil.getTypeByExpression(initializer);
            if (type == null) {
                return null;
            }
            return new PsiTypeResult(type, project);
        }
        return null;
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/RightSideTypeMacro.calculateQuickResult must not be null");
        }
        return null;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/RightSideTypeMacro.calculateLookupItems must not be null");
        }
        return LookupElement.EMPTY_ARRAY;
    }
}

