/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class SubtypesMacro
implements Macro {
    public String getName() {
        return "subtypes";
    }

    public String getDescription() {
        return "subtypes(TYPE)";
    }

    public String getDefaultValue() {
        return "A";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/SubtypesMacro.calculateResult must not be null");
        }
        if (params.length == 0) {
            return null;
        }
        return params[0].calculateQuickResult(context);
    }

    public Result calculateQuickResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/SubtypesMacro.calculateQuickResult must not be null");
        }
        return this.calculateResult(params, context);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/macro/SubtypesMacro.calculateLookupItems must not be null");
        }
        if (params.length == 0) {
            return LookupElement.EMPTY_ARRAY;
        }
        Result paramResult = params[0].calculateQuickResult(context);
        if (paramResult instanceof PsiTypeResult) {
            PsiType type = ((PsiTypeResult)paramResult).getType();
            HashSet types = new HashSet();
            types.add(type);
            PsiFile file = PsiDocumentManager.getInstance((Project)context.getProject()).getPsiFile(context.getEditor().getDocument());
            PsiElement element = file.findElementAt(context.getStartOffset());
            types.addAll(CodeInsightUtil.addSubtypes(type, element, false, (Condition<String>)Condition.TRUE));
            LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
            for (PsiType t : types) {
                JavaTemplateUtil.addTypeLookupItem(set, t);
            }
            return set.toArray(new LookupElement[set.size()]);
        }
        return LookupElement.EMPTY_ARRAY;
    }
}

