/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;

public class GosubInstruction
extends Instruction {
    private final int mySubprogramOffset;

    public GosubInstruction(int subprogramOffset) {
        this.mySubprogramOffset = subprogramOffset;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        int returnIndex = this.getIndex() + 1;
        stateBefore.pushOffset(returnIndex);
        Instruction nextInstruction = runner.getInstruction(this.mySubprogramOffset);
        return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, stateBefore)};
    }

    @Override
    public String toString() {
        return "GOSUB: " + this.mySubprogramOffset;
    }
}

