/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionTool
extends InspectionProfileEntry {
    private GlobalInspectionContextImpl myContext;
    protected static String ourOutputPath;

    public void initialize(@NotNull GlobalInspectionContextImpl context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionTool.initialize must not be null");
        }
        this.myContext = context;
        this.projectOpened(context.getProject());
    }

    public GlobalInspectionContextImpl getContext() {
        return this.myContext;
    }

    public RefManager getRefManager() {
        return this.myContext.getRefManager();
    }

    public abstract void runInspection(AnalysisScope var1, InspectionManager var2);

    public abstract void exportResults(Element var1);

    public abstract boolean isGraphNeeded();

    @Nullable
    public QuickFixAction[] getQuickFixes(RefEntity[] refElements) {
        return null;
    }

    @NotNull
    public abstract JobDescriptor[] getJobDescriptors();

    public boolean queryExternalUsagesRequests(InspectionManager manager) {
        return false;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/ex/InspectionTool.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return this.getDefaultLevel() != HighlightDisplayLevel.DO_NOT_SHOW;
    }

    public final String getDescriptionFileName() {
        return this.getShortName() + ".html";
    }

    public final String getFolderName() {
        return this.getShortName();
    }

    public void cleanup() {
        if (this.myContext != null) {
            this.projectClosed(this.myContext.getProject());
        }
        this.myContext = null;
    }

    public void finalCleanup() {
        this.cleanup();
    }

    public abstract HTMLComposerImpl getComposer();

    public abstract boolean hasReportedProblems();

    public abstract void updateContent();

    public abstract Map<String, Set<RefEntity>> getContent();

    @Nullable
    public abstract Map<String, Set<RefEntity>> getOldContent();

    public boolean isOldProblemsIncluded() {
        GlobalInspectionContextImpl context = this.getContext();
        return context != null && context.getUIOptions().SHOW_DIFF_WITH_PREVIOUS_RUN && this.getOldContent() != null;
    }

    @Nullable
    public Set<RefModule> getModuleProblems() {
        return null;
    }

    public abstract void ignoreCurrentElement(RefEntity var1);

    public abstract Collection<RefEntity> getIgnoredRefElements();

    public abstract void amnesty(RefEntity var1);

    public abstract boolean isElementIgnored(RefEntity var1);

    public abstract FileStatus getElementStatus(RefEntity var1);

    protected static FileStatus calcStatus(boolean old, boolean current) {
        if (old) {
            if (!current) {
                return FileStatus.DELETED;
            }
        } else if (current) {
            return FileStatus.ADDED;
        }
        return FileStatus.NOT_CHANGED;
    }

    protected static boolean contains(RefEntity element, Collection<RefEntity> entities) {
        for (RefEntity refEntity : entities) {
            if (!Comparing.equal((Object)refEntity, (Object)element)) continue;
            return true;
        }
        return false;
    }

    protected HighlightSeverity getCurrentSeverity(RefElement element) {
        PsiElement psiElement = element.getElement();
        if (psiElement != null && this.myContext != null) {
            Tools tools = this.myContext.getTools().get(this.getShortName());
            if (tools != null) {
                for (ScopeToolState state : tools.getTools()) {
                    if (state.getTool() != this) continue;
                    return this.myContext.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)this.getShortName()), psiElement).getSeverity();
                }
            }
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(this.getContext().getProject()).getInspectionProfile();
            HighlightDisplayLevel level = profile.getErrorLevel(HighlightDisplayKey.find((String)this.getShortName()), psiElement);
            return level.getSeverity();
        }
        return null;
    }

    protected static String getTextAttributeKey(Project project, HighlightSeverity severity, ProblemHighlightType highlightType) {
        if (highlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            return HighlightInfoType.DEPRECATED.getAttributesKey().getExternalName();
        }
        if (highlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL && severity == HighlightSeverity.ERROR) {
            return HighlightInfoType.WRONG_REF.getAttributesKey().getExternalName();
        }
        if (highlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return HighlightInfoType.UNUSED_SYMBOL.getAttributesKey().getExternalName();
        }
        return SeverityRegistrar.getInstance(project).getHighlightInfoTypeBySeverity(severity).getAttributesKey().getExternalName();
    }

    public static void setOutputPath(String output) {
        ourOutputPath = output;
    }

    @Nullable
    public IntentionAction findQuickFixes(CommonProblemDescriptor descriptor, String hint) {
        return null;
    }

    public InspectionNode createToolNode(InspectionRVContentProvider provider, InspectionTreeNode parentNode, boolean showSructure) {
        InspectionNode toolNode = new InspectionNode(this);
        provider.appendToolNodeContent(toolNode, parentNode, showSructure);
        return toolNode;
    }

    @Nullable
    public SuppressIntentionAction[] getSuppressActions() {
        return null;
    }
}

