/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.InspectionToolsFactory;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Factory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InspectionToolRegistrar {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolRegistrar");
    private final ArrayList<Factory<InspectionTool>> myInspectionToolFactories = new ArrayList();
    private final ArrayList<Function<String, InspectionTool>> myToolsProviders = new ArrayList();
    private final AtomicBoolean myToolsAreInitialized = new AtomicBoolean(false);
    private final AtomicBoolean myInspectionComponentsLoaded = new AtomicBoolean(false);
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");
    public final SearchableOptionsRegistrar myOptionsRegistrar;

    public InspectionToolRegistrar(SearchableOptionsRegistrar registrar) {
        this.myOptionsRegistrar = registrar;
    }

    public void ensureInitialized() {
        if (!this.myInspectionComponentsLoaded.getAndSet(true)) {
            THashSet providers = new THashSet();
            providers.addAll(Arrays.asList(ApplicationManager.getApplication().getComponents(InspectionToolProvider.class)));
            providers.addAll(Arrays.asList(Extensions.getExtensions((ExtensionPointName)InspectionToolProvider.EXTENSION_POINT_NAME)));
            this.registerTools(providers.toArray(new InspectionToolProvider[providers.size()]));
            for (InspectionToolsFactory factory : (InspectionToolsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionToolsFactory.EXTENSION_POINT_NAME)) {
                for (final InspectionProfileEntry profileEntry : factory.createTools()) {
                    this.myInspectionToolFactories.add(new Factory<InspectionTool>(){

                        public InspectionTool create() {
                            if (profileEntry instanceof LocalInspectionTool) {
                                return new LocalInspectionToolWrapper((LocalInspectionTool)profileEntry);
                            }
                            if (profileEntry instanceof GlobalInspectionTool) {
                                return new GlobalInspectionToolWrapper((GlobalInspectionTool)profileEntry);
                            }
                            return (InspectionTool)profileEntry;
                        }
                    });
                }
            }
        }
    }

    public void registerTools(InspectionToolProvider[] providers) {
        for (InspectionToolProvider provider : providers) {
            Class[] classes;
            for (Class aClass : classes = provider.getInspectionClasses()) {
                this.registerInspectionTool(aClass, true);
            }
        }
    }

    private Factory<InspectionTool> registerInspectionTool(final Class aClass, boolean store) {
        if (LocalInspectionTool.class.isAssignableFrom(aClass)) {
            return this.registerLocalInspection(aClass, store);
        }
        if (GlobalInspectionTool.class.isAssignableFrom(aClass)) {
            return this.registerGlobalInspection(aClass, store);
        }
        this.ensureInitialized();
        return this.registerInspectionToolFactory(new Factory<InspectionTool>(){

            public InspectionTool create() {
                return (InspectionTool)((Object)InspectionToolRegistrar.instantiateTool(aClass));
            }
        }, store);
    }

    public InspectionTool createInspectionTool(String shortName, InspectionProfileEntry profileEntry) {
        for (Function<String, InspectionTool> toolsProvider : this.myToolsProviders) {
            InspectionTool inspectionTool = (InspectionTool)((Object)toolsProvider.fun((Object)shortName));
            if (inspectionTool == null) continue;
            return inspectionTool;
        }
        Class<?> inspectionToolClass = profileEntry instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)profileEntry).getTool().getClass() : (profileEntry instanceof GlobalInspectionToolWrapper ? ((GlobalInspectionToolWrapper)profileEntry).getTool().getClass() : profileEntry.getClass());
        return (InspectionTool)((Object)this.registerInspectionTool(inspectionToolClass, false).create());
    }

    public static InspectionToolRegistrar getInstance() {
        return (InspectionToolRegistrar)ServiceManager.getService(InspectionToolRegistrar.class);
    }

    public Factory<InspectionTool> registerInspectionToolFactory(Factory<InspectionTool> factory) {
        return this.registerInspectionToolFactory(factory, true);
    }

    public Factory<InspectionTool> registerInspectionToolFactory(Factory<InspectionTool> factory, boolean store) {
        if (store) {
            this.myInspectionToolFactories.add(factory);
        }
        return factory;
    }

    public Function<String, InspectionTool> registerInspectionToolProvider(Function<String, InspectionTool> provider) {
        this.myToolsProviders.add(provider);
        return provider;
    }

    private Factory<InspectionTool> registerLocalInspection(final Class toolClass, boolean store) {
        return this.registerInspectionToolFactory(new Factory<InspectionTool>(){

            public InspectionTool create() {
                return new LocalInspectionToolWrapper((LocalInspectionTool)InspectionToolRegistrar.instantiateTool(toolClass));
            }
        }, store);
    }

    private Factory<InspectionTool> registerGlobalInspection(final Class aClass, boolean store) {
        return this.registerInspectionToolFactory(new Factory<InspectionTool>(){

            public InspectionTool create() {
                return new GlobalInspectionToolWrapper((GlobalInspectionTool)InspectionToolRegistrar.instantiateTool(aClass));
            }
        }, store);
    }

    public InspectionTool[] createTools() {
        this.ensureInitialized();
        InspectionTool[] tools = new InspectionTool[this.myInspectionToolFactories.size()];
        for (int i = 0; i < tools.length; ++i) {
            ProgressManager.checkCanceled();
            tools[i] = (InspectionTool)((Object)this.myInspectionToolFactories.get(i).create());
        }
        this.buildInspectionIndex(tools);
        return tools;
    }

    private static Object instantiateTool(Class toolClass) {
        try {
            Constructor constructor = toolClass.getDeclaredConstructor(ArrayUtil.EMPTY_CLASS_ARRAY);
            constructor.setAccessible(true);
            return constructor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
        }
        catch (SecurityException e) {
            LOG.error((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    private synchronized void buildInspectionIndex(final InspectionTool[] tools) {
        if (!this.myToolsAreInitialized.getAndSet(true)) {
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
                return;
            }
            app.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    for (InspectionTool tool : tools) {
                        InspectionToolRegistrar.this.processText(tool.getDisplayName().toLowerCase(), tool);
                        String description = tool.loadDescription();
                        if (description == null) continue;
                        String descriptionText = HTML_PATTERN.matcher(description).replaceAll(" ");
                        InspectionToolRegistrar.this.processText(descriptionText, tool);
                    }
                }
            });
        }
    }

    private void processText(@NonNls @NotNull String descriptionText, InspectionTool tool) {
        if (descriptionText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ex/InspectionToolRegistrar.processText must not be null");
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        LOG.assertTrue(this.myOptionsRegistrar != null);
        Set words = this.myOptionsRegistrar.getProcessedWordsWithoutStemming(descriptionText);
        for (String word : words) {
            this.myOptionsRegistrar.addOption(word, tool.getShortName(), tool.getDisplayName(), "Errors", "Inspections");
        }
    }
}

