/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.CompilerExcludes;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.taskdefs.DirSet;
import com.intellij.compiler.ant.taskdefs.Exclude;
import com.intellij.compiler.ant.taskdefs.Include;
import com.intellij.compiler.ant.taskdefs.Path;
import com.intellij.compiler.ant.taskdefs.PatternSet;
import com.intellij.compiler.ant.taskdefs.PatternSetRef;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;

public class ModuleChunkSourcepath
extends CompositeGenerator {
    private final VirtualFile[] mySourceRoots;
    private final VirtualFile[] myTestSourceRoots;

    public ModuleChunkSourcepath(Project project, ModuleChunk chunk, GenerationOptions genOptions) {
        Path sourcepath = new Path(BuildProperties.getSourcepathProperty((String)chunk.getName()));
        Path testSourcepath = new Path(BuildProperties.getTestSourcepathProperty((String)chunk.getName()));
        PatternSet excludedFromCompilation = new PatternSet(BuildProperties.getExcludedFromCompilationProperty((String)chunk.getName()));
        String moduleChunkBasedirProperty = BuildProperties.getModuleChunkBasedirProperty((ModuleChunk)chunk);
        Module[] modules = chunk.getModules();
        if (CompilerExcludes.isAvailable(project)) {
            excludedFromCompilation.add((Generator)new PatternSetRef("compiler.excluded"));
        }
        ArrayList<VirtualFile> sourceRootFiles = new ArrayList<VirtualFile>();
        ArrayList<VirtualFile> testSourceRootFiles = new ArrayList<VirtualFile>();
        for (Module module : modules) {
            ContentEntry[] contentEntries;
            String moduleName = module.getName();
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ModuleFileIndex moduleFileIndex = rootManager.getFileIndex();
            PatternSet excludedFromModule = new PatternSet(BuildProperties.getExcludedFromModuleProperty((String)moduleName));
            excludedFromModule.add((Generator)new PatternSetRef("ignored.files"));
            for (ContentEntry contentEntry : contentEntries = rootManager.getContentEntries()) {
                VirtualFile[] sourceRoots;
                VirtualFile file = contentEntry.getFile();
                if (file == null || !file.isInLocalFileSystem()) continue;
                VirtualFile dirSetRoot = this.getDirSetRoot(contentEntry);
                String dirSetRootRelativeToBasedir = GenerationUtils.toRelativePath((VirtualFile)dirSetRoot, (File)chunk.getBaseDir(), (String)moduleChunkBasedirProperty, (GenerationOptions)genOptions);
                DirSet sourcesDirSet = new DirSet(dirSetRootRelativeToBasedir);
                DirSet testSourcesDirSet = new DirSet(dirSetRootRelativeToBasedir);
                for (VirtualFile root : sourceRoots = contentEntry.getSourceFolderFiles()) {
                    if (!moduleFileIndex.isInContent(root)) continue;
                    this.addExcludePatterns(module, root, root, (CompositeGenerator)excludedFromModule, true);
                    Include include = new Include(VfsUtil.getRelativePath((VirtualFile)root, (VirtualFile)dirSetRoot, (char)'/'));
                    if (moduleFileIndex.isInTestSourceContent(root)) {
                        testSourcesDirSet.add((Generator)include);
                        testSourceRootFiles.add(root);
                        continue;
                    }
                    sourcesDirSet.add((Generator)include);
                    sourceRootFiles.add(root);
                }
                if (sourcesDirSet.getGeneratorCount() > 0) {
                    sourcepath.add((Generator)sourcesDirSet);
                }
                if (testSourcesDirSet.getGeneratorCount() <= 0) continue;
                testSourcepath.add((Generator)testSourcesDirSet);
            }
            if (excludedFromModule.getGeneratorCount() <= 0) continue;
            this.add((Generator)excludedFromModule);
            excludedFromCompilation.add((Generator)new PatternSetRef(BuildProperties.getExcludedFromModuleProperty((String)moduleName)));
        }
        this.mySourceRoots = VfsUtil.toVirtualFileArray(sourceRootFiles);
        this.myTestSourceRoots = VfsUtil.toVirtualFileArray(testSourceRootFiles);
        if (excludedFromCompilation.getGeneratorCount() > 0) {
            this.add((Generator)excludedFromCompilation, 1);
        }
        if (sourcepath.getGeneratorCount() > 0) {
            this.add((Generator)sourcepath, 1);
        }
        if (testSourcepath.getGeneratorCount() != 0) {
            this.add((Generator)testSourcepath, 1);
        }
    }

    public VirtualFile[] getSourceRoots() {
        return this.mySourceRoots;
    }

    public VirtualFile[] getTestSourceRoots() {
        return this.myTestSourceRoots;
    }

    private VirtualFile getDirSetRoot(ContentEntry contentEntry) {
        VirtualFile[] sourceFolderFiles;
        VirtualFile contentRoot = contentEntry.getFile();
        for (VirtualFile sourceFolderFile : sourceFolderFiles = contentEntry.getSourceFolderFiles()) {
            if (!contentRoot.equals(sourceFolderFile)) continue;
            return contentRoot.getParent();
        }
        return contentRoot;
    }

    private void addExcludePatterns(Module module, VirtualFile root, VirtualFile dir, CompositeGenerator generator, boolean parentIncluded) {
        VirtualFile[] children;
        if (FileTypeManager.getInstance().isFileIgnored(dir.getName())) {
            return;
        }
        boolean isIncluded = ModuleRootManager.getInstance((Module)module).getFileIndex().isInContent(dir);
        if (isIncluded != parentIncluded) {
            String relativePath = VfsUtil.getRelativePath((VirtualFile)dir, (VirtualFile)root, (char)'/');
            if (isIncluded) {
                generator.add((Generator)new Include(relativePath + "/**"));
            } else if (!this.isExcludedByDefault(dir.getName())) {
                generator.add((Generator)new Exclude(relativePath + "/**"));
            }
        }
        for (VirtualFile child : children = dir.getChildren()) {
            if (!child.isDirectory()) continue;
            this.addExcludePatterns(module, root, child, generator, isIncluded);
        }
    }

    private boolean isExcludedByDefault(String name) {
        return "CVS".equals(name) || "SCCS".equals(name) || ".DS_Store".equals(name);
    }
}

