/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.SymbolTable;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.impl.javaCompiler.DependencyProcessor;
import com.intellij.compiler.make.Cache;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.make.SourceFileFinder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.StringBuilderSpinAllocator;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class CacheUtils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.CacheUtils");

    public static String[] getParameterSignatures(MethodInfo methodDeclarationId, SymbolTable symbolTable) throws CacheCorruptedException {
        String descriptor = symbolTable.getSymbol(methodDeclarationId.getDescriptor());
        int endIndex = descriptor.indexOf(41);
        if (endIndex <= 0) {
            LOG.error("Corrupted method descriptor: " + descriptor);
        }
        return CacheUtils.parseSignature(descriptor.substring(1, endIndex));
    }

    private static String[] parseSignature(String signature) {
        ArrayList<String> list = new ArrayList<String>();
        String paramSignature = CacheUtils.parseParameterSignature(signature);
        while (paramSignature != null && !"".equals(paramSignature)) {
            list.add(paramSignature);
            signature = signature.substring(paramSignature.length());
            paramSignature = CacheUtils.parseParameterSignature(signature);
        }
        return ArrayUtil.toStringArray(list);
    }

    @Nullable
    private static String parseParameterSignature(String signature) {
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'B')) {
            return "B";
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'C')) {
            return "C";
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'D')) {
            return "D";
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'F')) {
            return "F";
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'I')) {
            return "I";
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'J')) {
            return "J";
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'S')) {
            return "S";
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'Z')) {
            return "Z";
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'L')) {
            return signature.substring(0, signature.indexOf(";") + 1);
        }
        if (StringUtil.startsWithChar((CharSequence)signature, (char)'[')) {
            String s = CacheUtils.parseParameterSignature(signature.substring(1));
            return s != null ? "[" + s : null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMethodSignature(String name, String descriptor) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(name);
            builder.append(descriptor.substring(0, descriptor.indexOf(41) + 1));
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public static boolean areArraysContentsEqual(int[] exceptions1, int[] exceptions2) {
        if (exceptions1.length != exceptions2.length) {
            return false;
        }
        if (exceptions1.length != 0) {
            TIntHashSet exceptionsSet = new TIntHashSet(exceptions1);
            for (int exception : exceptions2) {
                if (exceptionsSet.contains(exception)) continue;
                return false;
            }
        }
        return true;
    }

    public static Collection<VirtualFile> findDependentFiles(final CompileContextEx context, Set<VirtualFile> succesfullyCompiledJavaFiles, @Nullable DependencyProcessor additionalDependencyProcessor, @Nullable Function<Pair<int[], Set<VirtualFile>>, Pair<int[], Set<VirtualFile>>> filter) throws CacheCorruptedException {
        context.getProgressIndicator().setText(CompilerBundle.message((String)"progress.checking.dependencies", (Object[])new Object[0]));
        final DependencyCache dependencyCache = context.getDependencyCache();
        Pair deps = dependencyCache.findDependentClasses(context, context.getProject(), succesfullyCompiledJavaFiles, additionalDependencyProcessor);
        final Pair filteredDeps = filter != null ? (Pair)filter.fun(deps) : deps;
        final HashSet<VirtualFile> dependentFiles = new HashSet<VirtualFile>();
        final CacheCorruptedException[] _ex = new CacheCorruptedException[]{null};
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)context.getProject());
                    SourceFileFinder sourceFileFinder = new SourceFileFinder(context.getProject(), context);
                    Cache cache = dependencyCache.getCache();
                    for (int infoQName : (int[])filteredDeps.getFirst()) {
                        String sourceFileName;
                        String qualifiedName = dependencyCache.resolve(infoQName);
                        VirtualFile file = sourceFileFinder.findSourceFile(qualifiedName, sourceFileName = cache.getSourceFileName(infoQName));
                        if (file != null) {
                            if (compilerConfiguration.isExcludedFromCompilation(file)) continue;
                            dependentFiles.add(file);
                            if (!ApplicationManager.getApplication().isUnitTestMode()) continue;
                            LOG.assertTrue(file.isValid());
                            CompilerManagerImpl.addRecompiledPath(file.getPath());
                            continue;
                        }
                        LOG.info("No source file for " + dependencyCache.resolve(infoQName) + " found; source file name=" + sourceFileName);
                    }
                    for (VirtualFile file : (Set)filteredDeps.getSecond()) {
                        if (compilerConfiguration.isExcludedFromCompilation(file)) continue;
                        dependentFiles.add(file);
                        if (!ApplicationManager.getApplication().isUnitTestMode()) continue;
                        LOG.assertTrue(file.isValid());
                        CompilerManagerImpl.addRecompiledPath(file.getPath());
                    }
                }
                catch (CacheCorruptedException e) {
                    _ex[0] = e;
                }
            }
        });
        if (_ex[0] != null) {
            throw _ex[0];
        }
        context.getProgressIndicator().setText(CompilerBundle.message((String)"progress.found.dependent.files", (Object[])new Object[]{dependentFiles.size()}));
        return dependentFiles;
    }
}

