/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.make;

import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.compiler.make.CachingSearcher;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangedConstantsDependencyProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.make.ChangedConstantsDependencyProcessor");
    private final Project myProject;
    private final CachingSearcher mySearcher;
    private final DependencyCache myDependencyCache;
    private final int myQName;
    private final boolean mySkipExpressionResolve;
    private final FieldChangeInfo[] myChangedFields;
    private final FieldChangeInfo[] myRemovedFields;
    private static final long ANALYSIS_DURATION_THRESHOLD_MILLIS = 15000L;

    public ChangedConstantsDependencyProcessor(Project project, CachingSearcher searcher, DependencyCache dependencyCache, int qName, boolean skipExpressionResolve, FieldChangeInfo[] changedFields, FieldChangeInfo[] removedFields) {
        this.myProject = project;
        this.mySearcher = searcher;
        this.myDependencyCache = dependencyCache;
        this.myQName = qName;
        this.mySkipExpressionResolve = skipExpressionResolve;
        this.myChangedFields = changedFields;
        this.myRemovedFields = removedFields;
    }

    public void run() throws CacheCorruptedException {
        final CacheCorruptedException[] _ex = new CacheCorruptedException[]{null};
        DumbService.getInstance((Project)this.myProject).waitForSmartMode();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiClass[] classes;
                    String qName = ChangedConstantsDependencyProcessor.this.myDependencyCache.resolve(ChangedConstantsDependencyProcessor.this.myQName);
                    for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)ChangedConstantsDependencyProcessor.this.myProject).findClasses(qName.replace('$', '.'), GlobalSearchScope.allScope((Project)ChangedConstantsDependencyProcessor.this.myProject))) {
                        PsiField[] psiFields;
                        for (PsiField psiField : psiFields = aClass.getFields()) {
                            FieldChangeInfo changeInfo = ChangedConstantsDependencyProcessor.this.findChangeInfo(psiField);
                            if (changeInfo == null) continue;
                            ChangedConstantsDependencyProcessor.this.processFieldChanged(psiField, aClass, changeInfo.isAccessibilityChange);
                        }
                        for (FieldChangeInfo fieldChangeInfo : ChangedConstantsDependencyProcessor.this.myRemovedFields) {
                            ChangedConstantsDependencyProcessor.this.processFieldRemoved(fieldChangeInfo.fieldInfo, aClass);
                        }
                    }
                }
                catch (CacheCorruptedException e) {
                    _ex[0] = e;
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            }
        });
        if (_ex[0] != null) {
            throw _ex[0];
        }
    }

    private void processFieldRemoved(FieldInfo info, PsiClass aClass) throws CacheCorruptedException {
        PsiIdentifier[] identifiers;
        PsiFile containingFile;
        if (info.isPrivate()) {
            return;
        }
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)this.myProject);
        if (info.isPackageLocal() && (containingFile = aClass.getContainingFile()) instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            if (aPackage != null) {
                searchScope = PackageScope.packageScope((PsiPackage)aPackage, (boolean)false);
                searchScope = searchScope.intersectWith(aClass.getUseScope());
            }
        }
        PsiSearchHelper psiSearchHelper = PsiManager.getInstance((Project)this.myProject).getSearchHelper();
        long analysisStart = System.currentTimeMillis();
        boolean skipResolve = this.mySkipExpressionResolve;
        for (PsiIdentifier identifier : identifiers = ChangedConstantsDependencyProcessor.findIdentifiers(psiSearchHelper, this.myDependencyCache.resolve(info.getName()), (SearchScope)searchScope, (short)1)) {
            int qualifiedName;
            PsiClass ownerClass;
            PsiElement parent = identifier.getParent();
            if (!(parent instanceof PsiReferenceExpression)) continue;
            PsiReferenceExpression refExpr = (PsiReferenceExpression)parent;
            PsiReference reference = refExpr.getReference();
            boolean bl = skipResolve = skipResolve || System.currentTimeMillis() - analysisStart > 15000L;
            if (!skipResolve && reference != null && reference.resolve() != null || (ownerClass = ChangedConstantsDependencyProcessor.getOwnerClass((PsiElement)refExpr)) == null || ownerClass.equals(aClass) || !this.myDependencyCache.markClass(qualifiedName = this.myDependencyCache.getSymbolTable().getId(ownerClass.getQualifiedName()), true) || !LOG.isDebugEnabled()) continue;
            LOG.debug("Mark dependent class " + this.myDependencyCache.resolve(qualifiedName) + "; reason: some constants were removed from " + this.myDependencyCache.resolve(this.myQName));
        }
    }

    @NotNull
    private static PsiIdentifier[] findIdentifiers(PsiSearchHelper helper, @NotNull String identifier, @NotNull SearchScope searchScope, short searchContext) {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/make/ChangedConstantsDependencyProcessor.findIdentifiers must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/compiler/make/ChangedConstantsDependencyProcessor.findIdentifiers must not be null");
        }
        PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements();
        ChangedConstantsDependencyProcessor.processIdentifiers(helper, (PsiElementProcessor<PsiIdentifier>)processor, identifier, searchScope, searchContext);
        PsiIdentifier[] psiIdentifierArray = (PsiIdentifier[])processor.toArray((PsiElement[])PsiIdentifier.EMPTY_ARRAY);
        if (psiIdentifierArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/make/ChangedConstantsDependencyProcessor.findIdentifiers must not return null");
        }
        return psiIdentifierArray;
    }

    private static boolean processIdentifiers(PsiSearchHelper helper, final @NotNull PsiElementProcessor<PsiIdentifier> processor, @NotNull String identifier, @NotNull SearchScope searchScope, short searchContext) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/compiler/make/ChangedConstantsDependencyProcessor.processIdentifiers must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/compiler/make/ChangedConstantsDependencyProcessor.processIdentifiers must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/compiler/make/ChangedConstantsDependencyProcessor.processIdentifiers must not be null");
        }
        TextOccurenceProcessor processor1 = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                return !(element instanceof PsiIdentifier) || processor.execute((PsiElement)((PsiIdentifier)element));
            }
        };
        return helper.processElementsWithWord(processor1, searchScope, identifier, searchContext, true);
    }

    private void processFieldChanged(PsiField field, PsiClass aClass, boolean isAccessibilityChange) throws CacheCorruptedException {
        if (!isAccessibilityChange && field.hasModifierProperty("private")) {
            return;
        }
        HashSet<PsiElement> usages = new HashSet<PsiElement>();
        this.addUsages(field, usages, isAccessibilityChange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("++++++++++++++++++++++++++++++++++++++++++++++++");
            LOG.debug("Processing changed field: " + aClass.getQualifiedName() + "." + field.getName());
        }
        for (PsiElement usage : usages) {
            VirtualFile file;
            PsiFile containingFile;
            PsiClass ownerClass = ChangedConstantsDependencyProcessor.getOwnerClass(usage);
            if (LOG.isDebugEnabled()) {
                if (ownerClass != null) {
                    LOG.debug("Usage " + usage + " found in class: " + ownerClass.getQualifiedName());
                } else {
                    LOG.debug("Usage " + usage + " found in class: null");
                }
            }
            if (ownerClass != null && !ownerClass.equals(aClass)) {
                int qualifiedName = this.myDependencyCache.getSymbolTable().getId(ownerClass.getQualifiedName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Marking class id = [" + qualifiedName + "], name=[" + this.myDependencyCache.resolve(qualifiedName) + "]");
                }
                if (!this.myDependencyCache.markClass(qualifiedName, true) || !LOG.isDebugEnabled()) continue;
                LOG.debug("Marked dependent class " + this.myDependencyCache.resolve(qualifiedName) + "; reason: constants changed in " + this.myDependencyCache.resolve(this.myQName));
                continue;
            }
            if (ownerClass != null || (containingFile = usage.getContainingFile()) == null || (file = containingFile.getVirtualFile()) == null) continue;
            this.myDependencyCache.markFile(file);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("+++++++++++++++++++++++++++++++++++++++++++++++");
        }
    }

    private void addUsages(PsiField psiField, Collection<PsiElement> usages, boolean ignoreAccessScope) {
        Collection<PsiReference> references = this.mySearcher.findReferences((PsiElement)psiField, ignoreAccessScope);
        for (PsiReference ref : references) {
            PsiExpression initializer;
            if (!(ref instanceof PsiReferenceExpression)) continue;
            PsiElement e = ref.getElement();
            usages.add(e);
            PsiField ownerField = this.getOwnerField(e);
            if (ownerField == null || !ownerField.hasModifierProperty("final") || (initializer = ownerField.getInitializer()) == null || !PsiUtil.isConstantExpression((PsiExpression)initializer)) continue;
            this.addUsages(ownerField, usages, ignoreAccessScope);
        }
    }

    private PsiField getOwnerField(PsiElement element) {
        while (!(element instanceof PsiFile) && !(element instanceof PsiClass)) {
            if (element instanceof PsiField) {
                return (PsiField)element;
            }
            element = element.getParent();
        }
        return null;
    }

    private FieldChangeInfo findChangeInfo(PsiField field) throws CacheCorruptedException {
        String name = field.getName();
        for (FieldChangeInfo changeInfo : this.myChangedFields) {
            if (!name.equals(this.myDependencyCache.resolve(changeInfo.fieldInfo.getName()))) continue;
            return changeInfo;
        }
        return null;
    }

    @Nullable
    private static PsiClass getOwnerClass(PsiElement element) {
        while (!(element instanceof PsiFile)) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiJavaFile) {
                PsiClass psiClass = (PsiClass)element;
                if (JspPsiUtil.isInJspFile((PsiElement)psiClass)) {
                    return null;
                }
                PsiFile containingFile = psiClass.getContainingFile();
                if (containingFile == null) {
                    return null;
                }
                return StdLanguages.JAVA.equals(containingFile.getLanguage()) ? psiClass : null;
            }
            element = element.getParent();
        }
        return null;
    }

    public static class FieldChangeInfo {
        final FieldInfo fieldInfo;
        final boolean isAccessibilityChange;

        public FieldChangeInfo(FieldInfo fieldId) {
            this(fieldId, false);
        }

        public FieldChangeInfo(FieldInfo fieldInfo, boolean accessibilityChange) {
            this.fieldInfo = fieldInfo;
            this.isAccessibilityChange = accessibilityChange;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldChangeInfo fieldChangeInfo = (FieldChangeInfo)o;
            if (this.isAccessibilityChange != fieldChangeInfo.isAccessibilityChange) {
                return false;
            }
            return this.fieldInfo.equals(fieldChangeInfo.fieldInfo);
        }

        public int hashCode() {
            int result = this.fieldInfo.hashCode();
            result = 29 * result + (this.isAccessibilityChange ? 1 : 0);
            return result;
        }
    }
}

