/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.ExceptionRequest;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ExceptionBreakpoint
extends Breakpoint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");
    public boolean NOTIFY_CAUGHT = true;
    public boolean NOTIFY_UNCAUGHT = true;
    private String myQualifiedName;
    private String myPackageName;
    public static Icon ICON = IconLoader.getIcon((String)"/debugger/db_exception_breakpoint.png");
    public static Icon DISABLED_ICON = IconLoader.getIcon((String)"/debugger/db_disabled_exception_breakpoint.png");
    public static Icon DISABLED_DEP_ICON = IconLoader.getIcon((String)"/debugger/db_dep_exception_breakpoint.png");
    protected static final String READ_NO_CLASS_NAME = DebuggerBundle.message((String)"error.absent.exception.breakpoint.class.name", (Object[])new Object[0]);
    @NonNls
    public static final Key<ExceptionBreakpoint> CATEGORY = BreakpointCategory.lookup("exception_breakpoints");

    public ExceptionBreakpoint(Project project) {
        super(project);
    }

    public Key<? extends ExceptionBreakpoint> getCategory() {
        return CATEGORY;
    }

    protected ExceptionBreakpoint(Project project, String qualifiedName, String packageName) {
        super(project);
        this.myQualifiedName = qualifiedName;
        this.myPackageName = packageName == null ? this.calcPackageName(qualifiedName) : packageName;
    }

    private String calcPackageName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int dotIndex = qualifiedName.lastIndexOf(46);
        return dotIndex >= 0 ? qualifiedName.substring(0, dotIndex) : "";
    }

    @Override
    public String getClassName() {
        return this.myQualifiedName;
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public PsiClass getPsiClass() {
        return (PsiClass)PsiDocumentManager.getInstance((Project)this.myProject).commitAndRunReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return ExceptionBreakpoint.this.myQualifiedName != null ? DebuggerUtilsEx.findClass((String)ExceptionBreakpoint.this.myQualifiedName, (Project)ExceptionBreakpoint.this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)ExceptionBreakpoint.this.myProject)) : null;
            }
        });
    }

    @Override
    public String getDisplayName() {
        return DebuggerBundle.message((String)"breakpoint.exception.breakpoint.display.name", (Object[])new Object[]{this.myQualifiedName});
    }

    @Override
    public Icon getIcon() {
        if (!this.ENABLED) {
            Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
            return master == null ? DISABLED_ICON : DISABLED_DEP_ICON;
        }
        return ICON;
    }

    @Override
    public void reload() {
    }

    @Override
    public void createRequest(final DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.ENABLED || !debugProcess.isAttached() || debugProcess.areBreakpointsMuted() || !debugProcess.getRequestsManager().findRequests(this).isEmpty()) {
            return;
        }
        SourcePosition classPosition = (SourcePosition)PsiDocumentManager.getInstance((Project)this.myProject).commitAndRunReadAction((Computable)new Computable<SourcePosition>(){

            public SourcePosition compute() {
                PsiClass psiClass = DebuggerUtilsEx.findClass((String)ExceptionBreakpoint.this.myQualifiedName, (Project)ExceptionBreakpoint.this.myProject, (GlobalSearchScope)debugProcess.getSearchScope());
                return psiClass != null ? SourcePosition.createFromElement((PsiElement)psiClass) : null;
            }
        });
        if (classPosition == null) {
            this.createOrWaitPrepare(debugProcess, this.myQualifiedName);
        } else {
            this.createOrWaitPrepare(debugProcess, classPosition);
        }
    }

    @Override
    public void processClassPrepare(DebugProcess process, ReferenceType refType) {
        DebugProcessImpl debugProcess = (DebugProcessImpl)process;
        if (!this.ENABLED) {
            return;
        }
        ExceptionRequest request = debugProcess.getRequestsManager().createExceptionRequest(this, refType, this.NOTIFY_CAUGHT, this.NOTIFY_UNCAUGHT);
        debugProcess.getRequestsManager().enableRequest(request);
        if (LOG.isDebugEnabled()) {
            if (refType != null) {
                LOG.debug("Created exception request for reference type " + refType.name());
            } else {
                LOG.debug("Created exception request for reference type null");
            }
        }
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        if (event instanceof ExceptionEvent) {
            return ((ExceptionEvent)event).exception();
        }
        return super.getThisObject(context, event);
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        String exceptionName = this.myQualifiedName != null ? this.myQualifiedName : "java.lang.Throwable";
        String threadName = null;
        if (event instanceof ExceptionEvent) {
            ExceptionEvent exceptionEvent = (ExceptionEvent)event;
            try {
                exceptionName = exceptionEvent.exception().type().name();
                threadName = exceptionEvent.thread().name();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Location location = event.location();
        String locationQName = location.declaringType().name() + "." + location.method().name();
        String locationFileName = "";
        try {
            locationFileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            locationFileName = "";
        }
        int locationLine = Math.max(0, location.lineNumber());
        if (threadName != null) {
            return DebuggerBundle.message((String)"exception.breakpoint.console.message.with.thread.info", (Object[])new Object[]{exceptionName, threadName, locationQName, locationFileName, locationLine});
        }
        return DebuggerBundle.message((String)"exception.breakpoint.console.message", (Object[])new Object[]{exceptionName, locationQName, locationFileName, locationLine});
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void writeExternal(Element parentNode) throws WriteExternalException {
        super.writeExternal(parentNode);
        if (this.myQualifiedName != null) {
            parentNode.setAttribute("class_name", this.myQualifiedName);
        }
        if (this.myPackageName != null) {
            parentNode.setAttribute("package_name", this.myPackageName);
        }
    }

    @Override
    public PsiElement getEvaluationElement() {
        if (this.getClassName() == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.getClassName(), GlobalSearchScope.allScope((Project)this.myProject));
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        String className;
        super.readExternal(parentNode);
        this.myQualifiedName = className = parentNode.getAttributeValue("class_name");
        if (className == null) {
            throw new InvalidDataException(READ_NO_CLASS_NAME);
        }
        String packageName = parentNode.getAttributeValue("package_name");
        this.myPackageName = packageName != null ? packageName : this.calcPackageName(packageName);
    }
}

