/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.ThreadsDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;

public class ThreadsPanel
extends DebuggerTreePanel {
    @NonNls
    private static final String HELP_ID = "debugging.debugThreads";

    public ThreadsPanel(Project project, DebuggerStateManager stateManager) {
        super(project, stateManager);
        Disposable disposable = DebuggerAction.installEditAction((JTree)((Object)this.getThreadsTree()), "Debugger.EditFrameSource");
        this.registerDisposable(disposable);
        this.getThreadsTree().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                NodeDescriptorImpl descriptor;
                DebuggerTreeNodeImpl node;
                if (e.getKeyCode() == 10 && ThreadsPanel.this.getThreadsTree().getSelectionCount() == 1 && (node = (DebuggerTreeNodeImpl)ThreadsPanel.this.getThreadsTree().getLastSelectedPathComponent()) != null && (descriptor = node.getDescriptor()) instanceof StackFrameDescriptorImpl) {
                    ThreadsPanel.this.selectFrame(node);
                }
            }
        });
        this.add((Component)new JScrollPane((Component)((Object)this.getThreadsTree())), "Center");
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new ThreadsDebuggerTree(this.getProject());
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("Debugger.ThreadsPanelPopup");
        return ActionManager.getInstance().createActionPopupMenu("Debugger.ThreadsPanelPopup", (ActionGroup)group);
    }

    @Override
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    private void selectFrame(DebuggerTreeNodeImpl node) {
        StackFrameProxyImpl frame = ((StackFrameDescriptorImpl)node.getDescriptor()).getFrameProxy();
        DebuggerContextUtil.setStackFrame(this.getContextManager(), frame);
    }

    public ThreadsDebuggerTree getThreadsTree() {
        return (ThreadsDebuggerTree)this.getTree();
    }
}

