/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.debugger.engine.RemoteStateState;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.remote.RemoteConfigurable;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule> {
    public boolean USE_SOCKET_TRANSPORT;
    public boolean SERVER_MODE;
    public String SHMEM_ADDRESS;
    public String HOST;
    public String PORT;

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public RemoteConfiguration(String name, Project project, ConfigurationFactory configurationFactory) {
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, true), configurationFactory);
    }

    public RemoteConnection createRemoteConnection() {
        return new RemoteConnection(this.USE_SOCKET_TRANSPORT, this.HOST, this.USE_SOCKET_TRANSPORT ? this.PORT : this.SHMEM_ADDRESS, this.SERVER_MODE);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/execution/remote/RemoteConfiguration.getState must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/remote/RemoteConfiguration.getState must not be null");
        }
        GenericDebuggerRunnerSettings debuggerSettings = (GenericDebuggerRunnerSettings)env.getRunnerSettings().getData();
        debuggerSettings.LOCAL = false;
        debuggerSettings.setDebugPort(this.USE_SOCKET_TRANSPORT ? this.PORT : this.SHMEM_ADDRESS);
        debuggerSettings.setTransport(this.USE_SOCKET_TRANSPORT ? 0 : 1);
        return new RemoteStateState(this.getProject(), this.createRemoteConnection(), env.getRunnerSettings(), env.getConfigurationSettings());
    }

    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new RemoteConfigurable());
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        return group;
    }

    protected ModuleBasedConfiguration createInstance() {
        return new RemoteConfiguration(this.getName(), this.getProject(), RemoteConfigurationType.getInstance().getConfigurationFactories()[0]);
    }

    public Collection<Module> getValidModules() {
        return this.getAllModules();
    }
}

