/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.PrintableTestProxy;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.openapi.application.ModalityState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleView
extends BaseTestsOutputConsoleView {
    private SMTestRunnerResultsForm myResultsViewer;
    private final RunnerSettings myRunnerSettings;
    private final ConfigurationPerRunnerSettings myConfigurationPerRunnerSettings;
    @Nullable
    private final String mySplitterProperty;

    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationPerRunnerSettings) {
        this(consoleProperties, runnerSettings, configurationPerRunnerSettings, null);
    }

    public SMTRunnerConsoleView(TestConsoleProperties consoleProperties, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationPerRunnerSettings, @Nullable String splitterProperty) {
        super(consoleProperties);
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationPerRunnerSettings = configurationPerRunnerSettings;
        this.mySplitterProperty = splitterProperty;
    }

    @Override
    protected TestResultsPanel createTestResultsPanel() {
        this.myResultsViewer = new SMTestRunnerResultsForm((RunConfigurationBase)this.myProperties.getConfiguration(), this.getConsole().getComponent(), this.getConsole().createConsoleActions(), this.myProperties, this.myRunnerSettings, this.myConfigurationPerRunnerSettings, this.mySplitterProperty);
        return this.myResultsViewer;
    }

    @Override
    public void initUI() {
        super.initUI();
        this.myResultsViewer.addEventsListener(new TestResultsViewer.EventsListener(){

            @Override
            public void onTestNodeAdded(TestResultsViewer sender, SMTestProxy test) {
            }

            @Override
            public void onTestingStarted(TestResultsViewer sender) {
            }

            @Override
            public void onTestingFinished(TestResultsViewer sender) {
            }

            @Override
            public void onSelected(final @Nullable PrintableTestProxy selectedTestProxy, @NotNull TestResultsViewer viewer, @NotNull TestFrameworkRunningModel model) {
                if (viewer == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTRunnerConsoleView$1.onSelected must not be null");
                }
                if (model == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/testframework/sm/runner/ui/SMTRunnerConsoleView$1.onSelected must not be null");
                }
                if (selectedTestProxy == null) {
                    return;
                }
                SMRunnerUtil.runInEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        SMTRunnerConsoleView.this.getPrinter().updateOnTestSelected(selectedTestProxy);
                    }
                }, ModalityState.NON_MODAL);
            }
        });
    }

    public SMTestRunnerResultsForm getResultsViewer() {
        return this.myResultsViewer;
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.getPrinter().setCollectOutput(false);
    }
}

