/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.TextFieldWithHistory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class AlternativeJREPanel
extends JPanel {
    private final ComponentWithBrowseButton<TextFieldWithHistory> myPathField;
    private final JCheckBox myCbEnabled = new JCheckBox(ExecutionBundle.message((String)"run.configuration.use.alternate.jre.checkbox", (Object[])new Object[0]));
    final TextFieldWithHistory myFieldWithHistory;

    public AlternativeJREPanel() {
        super(new GridBagLayout());
        Sdk[] allJdks;
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, -2, 2, 2), 0, 0);
        this.add((Component)this.myCbEnabled, gc);
        this.myFieldWithHistory = new TextFieldWithHistory();
        this.myFieldWithHistory.setBorder(BorderFactory.createEtchedBorder());
        ArrayList<String> foundJdks = new ArrayList<String>();
        for (Sdk jdk : allJdks = ProjectJdkTable.getInstance().getAllJdks()) {
            foundJdks.add(jdk.getHomePath());
        }
        this.myFieldWithHistory.setHistory(foundJdks);
        this.myPathField = new ComponentWithBrowseButton((JComponent)this.myFieldWithHistory, null);
        this.myPathField.addBrowseFolderListener(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]), null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        gc.insets.left = 20;
        this.add((Component)this.myPathField, gc);
        InsertPathAction.addTo((JTextComponent)this.myFieldWithHistory.getTextEditor());
        gc.weighty = 1.0;
        this.add((Component)Box.createVerticalBox(), gc);
        this.myCbEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlternativeJREPanel.this.enabledChanged();
            }
        });
        this.enabledChanged();
    }

    private void enabledChanged() {
        boolean pathEnabled = this.isPathEnabled();
        GuiUtils.enableChildren(this.myPathField, (boolean)pathEnabled, (JComponent[])new JComponent[0]);
        this.myFieldWithHistory.invalidate();
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)((TextFieldWithHistory)this.myPathField.getChildComponent()).getText().trim());
    }

    private void setPath(String path) {
        ((TextFieldWithHistory)this.myPathField.getChildComponent()).setText(FileUtil.toSystemDependentName((String)(path == null ? "" : path)));
    }

    public boolean isPathEnabled() {
        return this.myCbEnabled.isSelected();
    }

    private void setPathEnabled(boolean b) {
        this.myCbEnabled.setSelected(b);
        this.enabledChanged();
    }

    public void init(String path, boolean isEnabled) {
        this.setPathEnabled(isEnabled);
        this.setPath(path);
    }
}

