/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.Storage;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;

public class StoringPropertyContainer
extends AbstractProperty.AbstractPropertyContainer<AbstractProperty<Boolean>> {
    private final HashMap<AbstractProperty<Boolean>, Boolean> myValues = new HashMap();
    private final Storage myStorage;

    public StoringPropertyContainer(@NonNls String groupName, PropertiesComponent propertiesComponent) {
        this((Storage)new Storage.PropertiesComponentStorage(groupName, propertiesComponent));
    }

    public StoringPropertyContainer(Storage storage) {
        this.myStorage = storage;
    }

    protected void setValueOf(AbstractProperty<Boolean> property, Object value) {
        this.myValues.put(property, (Boolean)value);
        this.onPropertyChanged(property, (Boolean)value);
        this.myStorage.put(property.getName(), this.stringValue(value));
    }

    private String stringValue(Object value) {
        return value.toString();
    }

    public boolean hasProperty(AbstractProperty property) {
        return this.myValues.containsKey(property);
    }

    protected Object getValueOf(AbstractProperty<Boolean> property) {
        Boolean value = this.myValues.get(property);
        if (value == null) {
            String stringValue = this.myStorage.get(property.getName());
            value = stringValue != null ? this.parseValue(stringValue) : (Boolean)property.getDefault((AbstractProperty.AbstractPropertyContainer)this);
            this.myValues.put(property, value);
        }
        return value;
    }

    private Boolean parseValue(String stringValue) {
        return Boolean.valueOf(stringValue);
    }

    protected <T> void onPropertyChanged(AbstractProperty<T> property, T value) {
    }
}

