/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindUsagesUtil;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.usageView.UsageViewUtil;
import javax.swing.JPanel;

public abstract class JavaFindUsagesDialog
extends AbstractFindUsagesDialog {
    protected final PsiElement myPsiElement;
    private StateRestoringCheckBox myCbIncludeOverloadedMethods;
    private boolean myIncludeOverloadedMethodsAvailable = false;

    protected JavaFindUsagesDialog(PsiElement element, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler) {
        super(project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, JavaFindUsagesDialog.isTextSearch(element, isSingleFile, handler), !isSingleFile && !element.getManager().isInProject(element));
        this.myPsiElement = element;
        this.myIncludeOverloadedMethodsAvailable = element instanceof PsiMethod && MethodSignatureUtil.hasOverloads((PsiMethod)((PsiMethod)element));
        this.init();
    }

    private static boolean isTextSearch(PsiElement element, boolean isSingleFile, FindUsagesHandler handler) {
        return FindUsagesUtil.isSearchForTextOccurencesAvailable(element, isSingleFile, handler);
    }

    @Override
    public void calcFindUsagesOptions(FindUsagesOptions options) {
        super.calcFindUsagesOptions(options);
        options.isIncludeOverloadUsages = this.myIncludeOverloadedMethodsAvailable && JavaFindUsagesDialog.isToChange(this.myCbIncludeOverloadedMethods) && this.myCbIncludeOverloadedMethods.isSelected();
    }

    @Override
    protected void doOKAction() {
        if (this.shouldDoOkAction()) {
            if (this.myIncludeOverloadedMethodsAvailable) {
                FindSettings.getInstance().setSearchOverloadedMethods(this.myCbIncludeOverloadedMethods.isSelected());
            }
        } else {
            return;
        }
        super.doOKAction();
    }

    @Override
    protected void addUsagesOptions(JPanel optionsPanel) {
        super.addUsagesOptions(optionsPanel);
        if (this.myIncludeOverloadedMethodsAvailable) {
            this.myCbIncludeOverloadedMethods = this.addCheckboxToPanel(FindBundle.message("find.options.include.overloaded.methods.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
    }

    private PsiManager getPsiManager() {
        return this.myPsiElement.getManager();
    }

    @Override
    protected boolean isInFileOnly() {
        return super.isInFileOnly() || this.myPsiElement != null && this.getPsiManager().getSearchHelper().getUseScope(this.myPsiElement) instanceof LocalSearchScope;
    }

    @Override
    public String getLabelText() {
        return StringUtil.capitalize((String)UsageViewUtil.getType(this.myPsiElement)) + " " + UsageViewUtil.getDescriptiveName(this.myPsiElement);
    }

    protected final PsiElement getPsiElement() {
        return this.myPsiElement;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(FindUsagesManager.getHelpID(this.myPsiElement));
    }
}

