/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.SpacingImpl;
import com.intellij.openapi.util.TextRange;

public class DependantSpacingImpl
extends SpacingImpl {
    private final TextRange myDependance;
    private static final int DEPENDENCE_CONTAINS_LF_MASK = 16;
    private static final int LF_WAS_USED_MASK = 32;

    public DependantSpacingImpl(int minSpaces, int maxSpaces, TextRange dependance, boolean keepLineBreaks, int keepBlankLines) {
        super(minSpaces, maxSpaces, 0, false, false, keepLineBreaks, keepBlankLines, false, 0);
        this.myDependance = dependance;
    }

    @Override
    int getMinLineFeeds() {
        if ((this.myFlags & 0x10) != 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void refresh(FormatProcessor formatter) {
        boolean value;
        boolean bl = value = this.wasLFUsed() || formatter.containsLineFeeds(this.myDependance);
        this.myFlags = value ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    public TextRange getDependancy() {
        return this.myDependance;
    }

    public final void setLFWasUsed(boolean value) {
        this.myFlags = value ? (this.myFlags |= 0x20) : (this.myFlags &= 0xFFFFFFDF);
    }

    public final boolean wasLFUsed() {
        return (this.myFlags & 0x20) != 0;
    }

    @Override
    public String toString() {
        return "<DependantSpacing: minSpaces=" + this.getMinSpaces() + " maxSpaces=" + this.getMaxSpaces() + " minLineFeeds=" + this.getMinLineFeeds() + " dep=" + this.myDependance + ">";
    }
}

