/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Indent;
import org.jetbrains.annotations.NonNls;

class IndentImpl
extends Indent {
    private final boolean myIsAbsolute;
    private final Type myType;
    private final int mySpaces;

    public boolean isContinuation() {
        return this.myType == Type.CONTINUATION_WITHOUT_FIRST;
    }

    public boolean isNone() {
        return this.getType() == Type.NONE;
    }

    public IndentImpl(Type type, boolean absolute, int spaces) {
        this.myType = type;
        this.myIsAbsolute = absolute;
        this.mySpaces = spaces;
    }

    public IndentImpl(Type type, boolean absolute) {
        this(type, absolute, 0);
    }

    Type getType() {
        return this.myType;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    boolean isAbsolute() {
        return this.myIsAbsolute;
    }

    @NonNls
    public String toString() {
        if (this.myType == Type.SPACES) {
            return "<Indent: SPACES(" + this.mySpaces + ")>";
        }
        return "<Indent: " + this.myType + (this.myIsAbsolute ? ":ABSOLUTE" : "") + ">";
    }

    static class Type {
        private final String myName;
        public static final Type SPACES = new Type("SPACES");
        public static final Type NONE = new Type("NONE");
        public static final Type LABEL = new Type("LABEL");
        public static final Type NORMAL = new Type("NORMAL");
        public static final Type CONTINUATION = new Type("CONTINUATION");
        public static final Type CONTINUATION_WITHOUT_FIRST = new Type("CONTINUATION_WITHOUT_FIRST");

        public Type(@NonNls String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

