/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.changes;

import com.intellij.history.core.IdPath;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.DeleteChangeAppliedState;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.changes.StructuralChangeNonAppliedState;
import com.intellij.history.core.storage.Content;
import com.intellij.history.core.storage.Stream;
import com.intellij.history.core.tree.Entry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeleteChange
extends StructuralChange<StructuralChangeNonAppliedState, DeleteChangeAppliedState> {
    public DeleteChange(String path) {
        super(path);
    }

    public DeleteChange(Stream s) throws IOException {
        super(s);
        ((DeleteChangeAppliedState)this.getAppliedState()).myAffectedEntry = s.readEntry();
    }

    @Override
    public void write(Stream s) throws IOException {
        super.write(s);
        s.writeEntry(((DeleteChangeAppliedState)this.getAppliedState()).myAffectedEntry);
    }

    @Override
    protected StructuralChangeNonAppliedState createNonAppliedState() {
        return new StructuralChangeNonAppliedState();
    }

    @Override
    protected DeleteChangeAppliedState createAppliedState() {
        return new DeleteChangeAppliedState();
    }

    public Entry getAffectedEntry() {
        return ((DeleteChangeAppliedState)this.getAppliedState()).myAffectedEntry;
    }

    @Override
    protected IdPath doApplyTo(Entry r, DeleteChangeAppliedState newState) {
        newState.myAffectedEntry = r.getEntry(this.getPath());
        IdPath idPath = newState.myAffectedEntry.getIdPath();
        this.removeEntry(newState.myAffectedEntry);
        return idPath;
    }

    @Override
    public void doRevertOn(Entry root) {
        Entry parent = this.getParent(root);
        parent.addChild(((DeleteChangeAppliedState)this.getAppliedState()).myAffectedEntry.copy());
    }

    @Override
    public boolean canRevertOn(Entry r) {
        return this.hasNoSuchEntry(this.getParent(r), ((DeleteChangeAppliedState)this.getAppliedState()).myAffectedEntry.getName());
    }

    private Entry getParent(Entry r) {
        return r.getEntry(this.getAffectedIdPath().getParent());
    }

    public boolean isDeletionOf(IdPath p) {
        return p.startsWith(this.getAffectedIdPath());
    }

    @Override
    public List<Content> getContentsToPurge() {
        ArrayList<Content> result = new ArrayList<Content>();
        this.collectContentsRecursively(((DeleteChangeAppliedState)this.getAppliedState()).myAffectedEntry, result);
        return result;
    }

    private void collectContentsRecursively(Entry e, List<Content> result) {
        if (e.isDirectory()) {
            for (Entry child : e.getChildren()) {
                this.collectContentsRecursively(child, result);
            }
        } else {
            result.add(e.getContent());
        }
    }

    @Override
    public void accept(ChangeVisitor v) throws IOException, ChangeVisitor.StopVisitingException {
        v.visit(this);
    }
}

