/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.LocalHistory;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PutLabelDialog
extends DialogWrapper {
    private IdeaGateway myGateway;
    private final VirtualFile myFile;
    private JTextField myNameField;
    private JRadioButton myProjectButton;
    private JRadioButton myFileButton;

    public PutLabelDialog(IdeaGateway gw, VirtualFile f) {
        super(gw.getProject(), false);
        this.setTitle(LocalHistoryBundle.message("put.label.dialog.title", new Object[0]));
        this.myGateway = gw;
        this.myFile = f;
        this.init();
        this.updateOkStatus();
    }

    public void dispose() {
        this.myGateway = null;
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.initNameField();
        JLabel l = new JLabel(LocalHistoryBundle.message("put.label.name", new Object[0]));
        l.setLabelFor(this.myNameField);
        panel.add((Component)l, this.atCell(0, 0));
        panel.add((Component)this.myNameField, this.atCell(1, 0));
        if (this.canPutLabelOnSelectedFile()) {
            this.initGroupButtons();
            panel.add((Component)new JLabel(LocalHistoryBundle.message("put.label.on", new Object[0])), this.atCell(0, 1));
            panel.add((Component)this.myProjectButton, this.atCell(1, 1));
            panel.add((Component)this.myFileButton, this.atCell(1, 2));
        }
        panel.setPreferredSize(new Dimension(300, 50));
        return panel;
    }

    private void initNameField() {
        this.myNameField = new JTextField();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                PutLabelDialog.this.updateOkStatus();
            }
        });
    }

    private void initGroupButtons() {
        this.myProjectButton = new JRadioButton(LocalHistoryBundle.message("put.label.on.project", new Object[0]));
        this.myFileButton = new JRadioButton(LocalHistoryBundle.message("put.label.on.file", this.myFile.getPath()));
        ButtonGroup group = new ButtonGroup();
        group.add(this.myProjectButton);
        group.add(this.myFileButton);
        this.myProjectButton.setSelected(true);
    }

    private GridBagConstraints atCell(int x, int y) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(4, 4, 4, 4);
        c.anchor = 13;
        c.fill = 1;
        c.gridx = x;
        c.gridy = y;
        c.weightx = x;
        return c;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private void updateOkStatus() {
        this.setOKActionEnabled(this.getLabelName().trim().length() > 0);
    }

    public void doOKAction() {
        if (this.canPutLabelOnSelectedFile() && this.myFileButton.isSelected()) {
            LocalHistory.putUserLabel((Project)this.myGateway.getProject(), (VirtualFile)this.myFile, (String)this.getLabelName());
        } else {
            LocalHistory.putUserLabel((Project)this.myGateway.getProject(), (String)this.getLabelName());
        }
        this.close(0);
    }

    private String getLabelName() {
        return this.myNameField.getText();
    }

    public void selectFileLabel() {
        this.myFileButton.setSelected(true);
    }

    public boolean canPutLabelOnSelectedFile() {
        return this.myFile != null && this.myGateway.getFileFilter().isAllowedAndUnderContentRoot(this.myFile);
    }
}

