/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.revisions.RecentChange;
import com.intellij.history.integration.FormatUtil;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.views.RecentChangeDialog;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class RecentChangesPopup {
    private final IdeaGateway myGateway;
    private final LocalVcs myVcs;

    public RecentChangesPopup(IdeaGateway gw, LocalVcs vcs) {
        this.myGateway = gw;
        this.myVcs = vcs;
    }

    public void show() {
        List<RecentChange> cc = this.myVcs.getRecentChanges();
        if (cc.isEmpty()) {
            String message = LocalHistoryBundle.message("recent.changes.to.changes", new Object[0]);
            this.myGateway.showMessage(message, this.getTitle());
            return;
        }
        final JList list = new JList(this.createModel(cc));
        list.setSelectionMode(0);
        list.setCellRenderer(new RecentChangesListCellRenderer());
        Runnable selectAction = new Runnable(){

            @Override
            public void run() {
                RecentChange c = (RecentChange)list.getSelectedValue();
                RecentChangesPopup.this.showRecentChangeDialog(c);
            }
        };
        this.showList(list, selectAction);
    }

    private ListModel createModel(List<RecentChange> cc) {
        DefaultListModel<RecentChange> m = new DefaultListModel<RecentChange>();
        for (RecentChange c : cc) {
            m.addElement(c);
        }
        return m;
    }

    private void showList(JList list, Runnable selectAction) {
        new PopupChooserBuilder(list).setTitle(this.getTitle()).setItemChoosenCallback(selectAction).createPopup().showCenteredInCurrentWindow(this.myGateway.getProject());
    }

    private void showRecentChangeDialog(RecentChange c) {
        RecentChangeDialog d = new RecentChangeDialog(this.myGateway, c);
        d.show();
    }

    private String getTitle() {
        return LocalHistoryBundle.message("recent.changes.popup.title", new Object[0]);
    }

    private static class RecentChangesListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myActionLabel = new JLabel("", 2);
        private final JLabel myDateLabel = new JLabel("", 4);
        private final JPanel mySpacePanel = new JPanel();

        public RecentChangesListCellRenderer() {
            this.myPanel.add((Component)this.myActionLabel, "West");
            this.myPanel.add((Component)this.myDateLabel, "East");
            this.myPanel.add((Component)this.mySpacePanel, "Center");
            Dimension d = new Dimension(40, this.mySpacePanel.getPreferredSize().height);
            this.mySpacePanel.setMinimumSize(d);
            this.mySpacePanel.setMaximumSize(d);
            this.mySpacePanel.setPreferredSize(d);
        }

        public Component getListCellRendererComponent(JList l, Object val, int i, boolean isSelected, boolean cellHasFocus) {
            RecentChange c = (RecentChange)val;
            this.myActionLabel.setText(c.getChangeName());
            this.myDateLabel.setText(FormatUtil.formatTimestamp(c.getChange().getTimestamp()));
            this.updateColors(isSelected);
            return this.myPanel;
        }

        private void updateColors(boolean isSelected) {
            Color bg = isSelected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
            Color fg = isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.setColors(bg, fg, this.myPanel, this.myActionLabel, this.myDateLabel, this.mySpacePanel);
        }

        private void setColors(Color bg, Color fg, JComponent ... cc) {
            for (JComponent c : cc) {
                c.setBackground(bg);
                c.setForeground(fg);
            }
        }
    }
}

