/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.LightColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Bookmark {
    private static final Icon TICK = IconLoader.getIcon((String)"/gutter/check.png");
    private final VirtualFile myFile;
    private final OpenFileDescriptor myTarget;
    private final RangeHighlighter myHighlighter;
    private final Project myProject;
    private String myDescription;
    private char myMnemonic = '\u0000';
    public static final Font MNEMONIC_FONT = new Font("Monospaced", 0, 11);

    public Bookmark(Project project, VirtualFile file, String description) {
        this(project, file, -1, description);
    }

    public Bookmark(Project project, VirtualFile file, int line, String description) {
        this.myFile = file;
        this.myProject = project;
        this.myDescription = description;
        if (line >= 0) {
            MarkupModelEx markup = (MarkupModelEx)this.getDocument().getMarkupModel(this.myProject);
            this.myHighlighter = markup.addPersistentLineHighlighter(line, 5001, null);
            if (this.myHighlighter != null) {
                this.myHighlighter.setGutterIconRenderer(new GutterIconRenderer(){

                    @NotNull
                    public Icon getIcon() {
                        Icon icon = Bookmark.this.getIcon();
                        if (icon == null) {
                            throw new IllegalStateException("@NotNull method com/intellij/ide/bookmarks/Bookmark$1.getIcon must not return null");
                        }
                        return icon;
                    }

                    public String getTooltipText() {
                        return StringUtil.escapeXml((String)Bookmark.this.getNotEmptyDescription());
                    }
                });
                this.myHighlighter.setErrorStripeMarkColor(Color.black);
                this.myHighlighter.setErrorStripeTooltip((Object)StringUtil.escapeXml((String)this.getNotEmptyDescription()));
            }
        } else {
            this.myHighlighter = null;
        }
        this.myTarget = new OpenFileDescriptor(project, file, line, -1);
    }

    public Document getDocument() {
        return FileDocumentManager.getInstance().getDocument(this.getFile());
    }

    public void release() {
        if (this.myHighlighter != null) {
            this.getDocument().getMarkupModel(this.myProject).removeHighlighter(this.myHighlighter);
        }
    }

    public Icon getIcon() {
        return this.myMnemonic == '\u0000' ? TICK : new MnemonicIcon(this.myMnemonic);
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public char getMnemonic() {
        return this.myMnemonic;
    }

    public void setMnemonic(char mnemonic) {
        this.myMnemonic = Character.toUpperCase(mnemonic);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public String getNotEmptyDescription() {
        return this.isDescriptionEmpty() ? null : this.myDescription;
    }

    public boolean isDescriptionEmpty() {
        return this.myDescription == null || this.myDescription.trim().length() == 0;
    }

    public boolean isValid() {
        return this.getFile().isValid() && (this.myHighlighter == null || this.myHighlighter.isValid());
    }

    public void navigate() {
        this.myTarget.navigate(true);
    }

    public int getLine() {
        if (this.myHighlighter != null && this.myHighlighter.isValid()) {
            return this.myHighlighter.getDocument().getLineNumber(this.myHighlighter.getStartOffset());
        }
        return this.myTarget.getLine();
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public String getQualifiedName() {
        ItemPresentation presentation;
        StructureViewModel model;
        Object element;
        String presentableUrl = this.myFile.getPresentableUrl();
        if (this.myFile.isDirectory() || this.myHighlighter == null) {
            return presentableUrl;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        if (psiFile == null) {
            return presentableUrl;
        }
        StructureViewBuilder builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(psiFile);
        if (builder instanceof TreeBasedStructureViewBuilder && (element = (model = ((TreeBasedStructureViewBuilder)builder).createStructureViewModel()).getCurrentEditorElement()) instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            presentableUrl = ((NavigationItem)element).getName() + " " + presentation.getLocationString();
        }
        return IdeBundle.message((String)"bookmark.file.X.line.Y", (Object[])new Object[]{presentableUrl, this.myHighlighter.getDocument().getLineNumber(this.myHighlighter.getStartOffset()) + 1});
    }

    private static class MnemonicIcon
    implements Icon {
        private final char myMnemonic;

        private MnemonicIcon(char mnemonic) {
            this.myMnemonic = mnemonic;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(LightColors.YELLOW);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(Color.gray);
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(Color.black);
            g.setFont(MNEMONIC_FONT);
            g.drawString(Character.toString(this.myMnemonic), x + 2, y + this.getIconHeight() - 2);
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }
}

