/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FavoritesTreeStructure
extends ProjectTreeStructure {
    private final FavoritesManager myFavoritesManager;
    private final String myListName;

    public FavoritesTreeStructure(Project project, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesTreeStructure.<init> must not be null");
        }
        super(project, "Favorites");
        this.myListName = name;
        this.myFavoritesManager = FavoritesManager.getInstance(project);
    }

    @Override
    protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
        return new FavoritesRootNode();
    }

    public void rootsChanged() {
        ((FavoritesRootNode)((Object)this.getRootElement())).rootsChanged();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<AbstractTreeNode> getFavoritesRoots() {
        Collection<AbstractTreeNode> collection;
        List<Pair<AbstractUrl, String>> urls = this.myFavoritesManager.getFavoritesListRootUrls(this.myListName);
        if (urls == null) {
            collection = Collections.emptyList();
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeStructure.getFavoritesRoots must not return null");
            return collection;
        }
        collection = this.createFavoritesRoots(urls);
        if (collection != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeStructure.getFavoritesRoots must not return null");
    }

    @Override
    public Object[] getChildElements(Object element) {
        if (!(element instanceof AbstractTreeNode)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        AbstractTreeNode favoritesTreeElement = (AbstractTreeNode)element;
        try {
            if (element != this.getRootElement()) {
                return super.getChildElements(favoritesTreeElement);
            }
            HashSet<Object> result = new HashSet<Object>();
            for (AbstractTreeNode abstractTreeNode : this.getFavoritesRoots()) {
                Object val = abstractTreeNode.getValue();
                if (val == null || val instanceof PsiElement && !((PsiElement)val).isValid() || val instanceof SmartPsiElementPointer && ((SmartPsiElementPointer)val).getElement() == null) continue;
                boolean isInvalid = false;
                for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject)) {
                    if (!nodeProvider.isInvalidElement(val)) continue;
                    isInvalid = true;
                    break;
                }
                if (isInvalid) continue;
                result.add(abstractTreeNode);
            }
            if (result.isEmpty()) {
                result.add(this.getEmptyScreen());
            }
            return ArrayUtil.toObjectArray(result);
        }
        catch (Exception exception) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private AbstractTreeNode<String> getEmptyScreen() {
        return new AbstractTreeNode<String>(this.myProject, IdeBundle.message((String)"favorites.empty.screen", (Object[])new Object[0])){

            @NotNull
            public Collection<AbstractTreeNode> getChildren() {
                List<AbstractTreeNode> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeStructure$1.getChildren must not return null");
                }
                return list;
            }

            public void update(PresentationData presentation) {
                presentation.setPresentableText((String)this.getValue());
            }
        };
    }

    @Override
    public Object getParentElement(Object element) {
        AbstractTreeNode parent = null;
        if (element == this.getRootElement()) {
            return null;
        }
        if (element instanceof AbstractTreeNode) {
            parent = ((AbstractTreeNode)element).getParent();
        }
        if (parent == null) {
            return this.getRootElement();
        }
        return parent;
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        FavoritesTreeNodeDescriptor favoritesTreeNodeDescriptor = new FavoritesTreeNodeDescriptor(this.myProject, parentDescriptor, (AbstractTreeNode)element);
        if (favoritesTreeNodeDescriptor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeStructure.createDescriptor must not return null");
        }
        return favoritesTreeNodeDescriptor;
    }

    @NotNull
    private Collection<AbstractTreeNode> createFavoritesRoots(@NotNull List<Pair<AbstractUrl, String>> urls) {
        if (urls == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/favoritesTreeView/FavoritesTreeStructure.createFavoritesRoots must not be null");
        }
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (Pair<AbstractUrl, String> pair : urls) {
            AbstractUrl abstractUrl = (AbstractUrl)pair.getFirst();
            Object[] path = abstractUrl.createPath(this.myProject);
            if (path == null || path.length < 1 || path[0] == null) continue;
            try {
                String className = (String)pair.getSecond();
                Class<?> nodeClass = Class.forName(className);
                AbstractTreeNode node = ProjectViewNode.createTreeNode(nodeClass, (Project)this.myProject, (Object)path[path.length - 1], (ViewSettings)this);
                result.add(node);
            }
            catch (Exception e) {}
        }
        ArrayList<AbstractTreeNode> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeStructure.createFavoritesRoots must not return null");
        }
        return arrayList;
    }

    private class FavoritesRootNode
    extends AbstractTreeNode<String> {
        private Collection<AbstractTreeNode> myFavoritesRoots;

        public FavoritesRootNode() {
            super(FavoritesTreeStructure.this.myProject, (Object)"");
        }

        @NotNull
        public Collection<AbstractTreeNode> getChildren() {
            if (this.myFavoritesRoots == null) {
                this.myFavoritesRoots = FavoritesTreeStructure.this.getFavoritesRoots();
            }
            Collection<AbstractTreeNode> collection = this.myFavoritesRoots;
            if (collection == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/favoritesTreeView/FavoritesTreeStructure$FavoritesRootNode.getChildren must not return null");
            }
            return collection;
        }

        public void rootsChanged() {
            this.myFavoritesRoots = null;
        }

        public void update(PresentationData presentation) {
        }
    }
}

