/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;

public class RenameFavoritesListAction
extends AnAction
implements DumbAware {
    public RenameFavoritesListAction() {
        super(IdeBundle.message((String)"action.rename.favorites.list", (Object[])new Object[0]), IdeBundle.message((String)"action.rename.favorites.list", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/menu-replace.png"));
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        final Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        final FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        String newName = Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.input.favorites.list.new.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.favorites.list", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)listName, (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            public boolean canClose(String inputString) {
                boolean isNew;
                Object[] lists = favoritesManager.getAvailableFavoritesLists();
                boolean bl = isNew = ArrayUtil.find((Object[])lists, (Object)inputString.trim()) == -1;
                if (!isNew) {
                    Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.favorites.list.already.exists", (Object[])new Object[]{inputString.trim()}), (String)IdeBundle.message((String)"title.unable.to.add.favorites.list", (Object[])new Object[0]));
                    return false;
                }
                return inputString.trim().length() > 0;
            }
        });
        if (listName != null && newName != null) {
            favoritesManager.renameFavoritesList(listName, newName);
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        e.getPresentation().setEnabled(listName != null && !listName.equals(project.getName()));
    }
}

