/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Properties;

public class JavaCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    public static PsiClass createClassOrInterface(Project project, PsiDirectory directory, String content, boolean reformat, String extension) throws IncorrectOperationException {
        PsiElement addedElement;
        PsiFile psiFile;
        if (extension == null) {
            extension = StdFileTypes.JAVA.getDefaultExtension();
        }
        if (!((psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("myclass." + extension, content)) instanceof PsiJavaFile)) {
            throw new IncorrectOperationException("This template did not produce a Java class or an interface\n" + psiFile.getText());
        }
        PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
        PsiClass[] classes = psiJavaFile.getClasses();
        if (classes.length == 0) {
            throw new IncorrectOperationException("This template did not produce a Java class or an interface\n" + psiFile.getText());
        }
        PsiClass createdClass = classes[0];
        if (reformat) {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiJavaFile);
        }
        String className = createdClass.getName();
        String fileName = className + "." + extension;
        if (createdClass.isInterface()) {
            JavaDirectoryService.getInstance().checkCreateInterface(directory, className);
        } else {
            JavaDirectoryService.getInstance().checkCreateClass(directory, className);
        }
        LanguageLevel ll = JavaDirectoryService.getInstance().getLanguageLevel(directory);
        if (ll.compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
            if (createdClass.isAnnotationType()) {
                throw new IncorrectOperationException("Annotations only supported at language level 1.5 and higher");
            }
            if (createdClass.isEnum()) {
                throw new IncorrectOperationException("Enums only supported at language level 1.5 and higher");
            }
        }
        if ((addedElement = directory.add((PsiElement)(psiJavaFile = (PsiJavaFile)psiJavaFile.setName(fileName)))) instanceof PsiJavaFile) {
            psiJavaFile = (PsiJavaFile)addedElement;
            return psiJavaFile.getClasses()[0];
        }
        PsiFile containingFile = addedElement.getContainingFile();
        throw new IncorrectOperationException("Selected class file name '" + containingFile.getName() + "' mapped to not java file type '" + containingFile.getFileType().getDescription() + "'");
    }

    static void hackAwayEmptyPackage(PsiJavaFile file, FileTemplate template, Properties props) throws IncorrectOperationException {
        PsiPackageStatement packageStatement;
        if (!template.isJavaClassTemplate()) {
            return;
        }
        String packageName = props.getProperty("PACKAGE_NAME");
        if ((packageName == null || packageName.length() == 0 || packageName.equals("PACKAGE_NAME")) && (packageStatement = file.getPackageStatement()) != null) {
            packageStatement.delete();
        }
    }

    @Override
    public boolean handlesTemplate(FileTemplate template) {
        FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
        return fileType.equals(StdFileTypes.JAVA);
    }

    @Override
    public PsiElement createFromTemplate(Project project, PsiDirectory directory, String fileName, FileTemplate template, String templateText, Properties props) throws IncorrectOperationException {
        String extension = template.getExtension();
        PsiClass result = JavaCreateFromTemplateHandler.createClassOrInterface(project, directory, templateText, template.isAdjust(), extension);
        JavaCreateFromTemplateHandler.hackAwayEmptyPackage((PsiJavaFile)result.getContainingFile(), template, props);
        return result;
    }

    @Override
    public boolean canCreate(PsiDirectory[] dirs) {
        for (PsiDirectory dir : dirs) {
            if (JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
            return true;
        }
        return false;
    }
}

